/***************************************************************************
                          CDView.h  -  CDView Widget
                             -------------------                                         

    version              :                                   
    begin                : Mon Dez 14 19:01:57 CET 1998
                                           
    copyright            : (C) 1998 by Denis Oliver Kropp                         
    email                : dok@fischlustig.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// alter mach kaffe
#ifndef _CDVIEW_H
#define _CDVIEW_H

#include <qframe.h>
#include <qpixmap.h>
#include "koverfile.h"

/**
 * CDView draws the cover in mini form, print preview or direct to the printer.
 * @author Denis Oliver Kropp (dok@fischlustig.de)
 */
class CDView : public QFrame
{
	Q_OBJECT
public:
	/**
	 * CDView constructor.
	 * @param parent Optional pointer to the parent widget.
	 * @param name Optional pointer to the name.
	 */
	CDView( KoverFile* _kover_file, QWidget* parent = NULL, const char* name = NULL );
  
	/**
	 * Opens a printer configuration dialog and prints or not.
	 */
	void printKover();
  
	/**
	 * Normally CDView draws the cover with a scale of 2/5.<br>
	 * If you set the preview mode then theres no scale.
	 * @param preview true=print preview; false=normal 2/5 scale
	 */
	void showPreview( bool preview = true );

public slots:
	/**
	 * Tells CDView that the data within KoverFile changed.
	 */
	void dataChanged(bool image);

signals:
	/**
	 * This signal is emitted when the user clicks into the CDView during preview.
	 */
	void stopPreview();

protected:
	void paintEvent( QPaintEvent * );
	void mousePressEvent( QMouseEvent * );
	void drawBooklet( QPainter *p, int X, int Y );
	void drawInlet( QPainter *p, int X, int Y );
	
private:
	QPixmap		images[3];
	KoverFile*	kover_file;
	bool			previewMode;
	QPrinter*		printer;
};

#endif

