// -*- C++ -*-

//
//  konserver
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef mystring_included
#define mystring_included

//  Contains a null teminated string
//  len does not include the null character
//
//  MyString test("Test");
//  test.len() == 4

extern "C" {
#include <stdio.h>
}

class MyString {
public:
  MyString ();
  MyString (const MyString &s);
  MyString (const char *s);
  MyString (unsigned long l, char c);
  ~MyString () { if(len != 0 ) delete [] buf; }

  unsigned long length() { return len; }
  MyString      substr(unsigned long begin, unsigned long l);
  MyString&     assign( const MyString &s, unsigned long begin, unsigned long l);
  unsigned long find( char c );
  const char * c_str() { return buf; }

  operator const char *() { return buf; }
  operator ==( const MyString &s );
  operator ==( const char *s ) { return (*this == ((MyString) s)); }
  operator !=( const MyString &s ) { return !(*this == s); }
  operator !=( const char *s ) { return !(*this == ((MyString) s)); }
  char& operator []( unsigned long pos );
  MyString& operator =( const MyString &s ) { return assign( s, 0, s.len ); }
  MyString& operator =( const char *s ) { return assign( (MyString) s, 0, ((MyString) s).len ); }


protected:
  char          *buf;
  unsigned long  len;
  static char    empty;
};


inline char& MyString::operator []( unsigned long pos )
{
  if( pos >= len )
    fprintf(stderr, "MyString::operator[] index out of range!\n" );
  return buf[pos];
}



#endif  /* mystring_included */
