// -*- C++ -*-

//
//  konserver
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef konserver_included
#define konserver_included

extern "C" {
#include <netinet/in.h>
#include <sys/socket.h>
}

//#include <string.h>
#include "mystring.h"

#include "PipeCom.h"

class User;
class UserData;
class WatchData;
class MessageData;

class Clients
{
public:
  Clients () { list = 0; }
  ~Clients () { remove(); }

  void insert(unsigned long i, struct sockaddr_in *a);
  void remove(unsigned long id);
  struct sockaddr_in *search(unsigned long id);
  int sendActive(unsigned long cid, unsigned long rid, short active);
  int sendMsg(unsigned long cid, unsigned long rid, MyString msg, User *rec, MyString date);
  int serverShutdown();
  void gotKeepAlive(unsigned long id);
  void processAliveCounter(WatchData *wdata);

protected:
  void remove();
  int connect(unsigned long id);
  int disconnect();
  class Item {
    friend class Clients;
  private:
    Item (unsigned long id, struct sockaddr_in *a, Item *item = 0);

    unsigned long      id;
    struct sockaddr_in addr;
    short              alive;
    Item              *next;
  };
  
  int      sock;
  Item    *list;
  PipeCom *l_pipe;
};


class Konserver
{
public:
  Konserver ( MyString config_file );
  ~Konserver ();

  int loop();
  //void exportUserDatabase();
  //void importUserDatabase();

protected:
  int connectClient(int fd_client);
  int parseRequest(int allowed);
  int checkId(unsigned long id);
  int newClient();
  int delClient();
  int changeClient();
  int connect();
  int disconnect();
  int searchUser();
  int addWatchlist();
  int removeWatchlist();
  int sendMsg();
  int termination_handler(int signum);
  int getMsg();
  int sendQueuedMsg();
  int readConfig( MyString config_file );
  int getUserInfo();

  PipeCom       *c_pipe;
  fd_set         input_set;    // active descriptor set
  int            serversock;   // fd to serversocket
  struct         sockaddr_in servername; // name of serversocket
  struct         sockaddr_in clientname; // name of clientsocket
  struct         sockaddr_in keepname;   // name of udp keep alive socket
  int            keepsocket;             // fd to keep alive socket
  unsigned long  cid;          // id of currently connected client
  MyString       cpasswd;      // passwd of currently connected client

  MyString       databasedir;
  unsigned long  ip_net[MAX_RULES];
  unsigned long  ip_mask[MAX_RULES];
  unsigned short nr_rules;

  UserData      *udata;
  WatchData     *wdata;
  MessageData   *mdata;
  Clients       *clist;
};

inline Clients::Item::Item(unsigned long i, struct sockaddr_in *a, Item *item)
{
  id = i; 
  addr.sin_family = a->sin_family;
  addr.sin_addr.s_addr = a->sin_addr.s_addr;
  addr.sin_port = a->sin_port;
  next = item; 
}


#endif /* konserver_included */
