#include "passdialog.h"

#include <qpushbutton.h> 
#include <qlabel.h>
#include <qlineedit.h> 
#include <qstring.h>
#include <qpixmap.h>

#include <kapp.h>
#include <kiconloader.h>
#include <klocale.h>

CPassDialog::CPassDialog(QString address, QWidget* parent, const char* name) : QDialog(parent, name, TRUE)
{
  QString message;

  setCaption(i18n("Password"));

  message = i18n("Please enter password for\n");
  message += address;

  fStaticIcon = new QLabel(this, "StaticIcon");
  fStaticIcon->setPixmap(Icon("knewmail_bubble_query.xpm"));
  fStaticIcon->setGeometry(160, 5, 32, 32);

  fStaticPassword = new QLabel(i18n(message), this, "StaticPassword");
  fStaticPassword->setGeometry(10, 10, 150, 40);

  fPassword = new QLineEdit(this, "Password");
  fPassword->setGeometry(10, 50, 180, 20);
  fPassword->setEchoMode(QLineEdit::Password);
  fPassword->setText("");

  fOk = new QPushButton(i18n("Ok"), this, "Ok");
  fOk->setGeometry(75, 80, 50, 20);

  connect(fOk, SIGNAL(clicked()), this, SLOT(accept()));
}

CPassDialog::~CPassDialog()
{
  disconnect(fOk, SIGNAL(clicked()), this, SLOT(accept()));

  //delete(fStaticIcon);
  delete(fStaticPassword);
  delete(fPassword);
  delete(fOk);
}

QString CPassDialog::password()
{
  return fPassword->text();
}

#include "passdialog.moc"
