#ifndef KNEWMAILENGINE_H
#define KNEWMAILENGINE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>

#include <qwidget.h>
#include <qlist.h>

#include "resource.h"

class ClientManager;
class QTimer;

/** The KNewMail engine is the class that will keep track of the
 * time between checks and run a ckeck if necessary. After running
 * a check, it will emit the signal that a check has been done and 
 * will also perform whatever notification options the user
 * has selected. 
 *
 * @author Mike Pilone
 */
class KNewMailEngine : public QObject
{
  Q_OBJECT

public:
  KNewMailEngine(QList<ServerStruct>* mailboxList, QWidget *parent = 0, const char *name = 0);
  ~KNewMailEngine();

  /** triggers a mail check. This function is independant of the timer and
   * will over rule the active setting. Therefore the engine will always attempt
   * to check mail when this function is called.
   */
  void checkMail();

  /** called when the config dialog either opens or closes. This allows
   * us to stop the timer and wait for the config box to close. Once
   * the config box closes we should reload all of our variables from
   * there incase they changed.
   */
  void configDialogActivated(int state); 



protected:
  /** a Pointer to the mailbox list.
   */
  QList<ServerStruct>* fMailboxList;

  /** The headerlist of mail headers.
   */
  QList<HeaderStruct> fFullHeaderList;

  /** The headerlist that stores all the headers of the new mail
   * only
   */
  QList<HeaderStruct> fNewMsgHeaderList;

  /** The headerlist that stores all the headers of the new mail
   * only
   */
  QList<HeaderStruct> fCurrentHeaderList;

  /** Keeps track of when we should check for mail.
   */
  QTimer *fCheckMailTimer;

  /** This is the class that handles all the socket/pop communications.
   */
  ClientManager* fClientManager;

  /** loads the time for the timer from the config and tells it to start.
   */
  void initCheckMailTimer();

  /** Takes the serverInfo given and attempts to process remote mailbox
   */
  //void processRemoteMailbox(ServerStruct* serverInfo, QList<HeaderStruct>* headerList);

  /** Takes the serverInfo given and attemps to process local mailbox
   */
  //void processLocalMailbox(ServerStruct* serverInfo, QList<HeaderStruct>* headerList);

  /** Compares the currentHeaderList with the HeaderList and lokks for items
   * not duplicated. Those items will be inserted into the newMsgHeaderList
   */
  void processLists(QList<HeaderStruct>* currentHeaderList, QList<HeaderStruct>* newMsgHeaderList, QList<HeaderStruct>* fullHeaderList);

protected slots:
  /** called when the fCheckMailTimer expires. This method should also be called
   * by the check mail function.
   */
  void slotCheckMail();

signals:
  /** Emitted when a check is performed
   */
  void checkPerformed(QList<HeaderStruct>*, QList<HeaderStruct>*);

};

#endif
