#ifndef __CLIENTMANAGER_H_
#define __CLIENTMANAGER_H_

#include <qobject.h>
#include <qwidget.h>
#include <qlist.h>
#include <qstring.h>

#include "resource.h"
class ClientLocal;
class ClientPop3;
class ClientImap;

class ClientManager //: public QObject
{
  //Q_OBJECT

public:
  ClientManager(QWidget* parent);
  ~ClientManager();

 
  /** Used to check a pop3 for mail. Don't call this method until you have called connect and you are sure a 
   * connection is open. If you do call this with out a connection, it should be able to recover. It works by
   * calling a series of commands, like USER, STAT, PASS and then calls _GetSocketInput to get the results of
   * the command. At anytime during execution it can and will bail out if things go wrong someplace.
   *
   * @param headerlist A list of HeaderInfoStructs that will be filled when mail is found waiting on the
   * server. This list should be created and emptied before being passed in because this method will just attempt
   * to append to the end of it.
   *
   * @param timeOutLength This is the length of time KNewMail will sit and wait for the server to respond
   * to a certain request. About 8 seconds is recommended. This value should be in seconds.
   */
  bool checkMail(QList<HeaderStruct>* headerList, ServerStruct *serverInfo);

private:
 
 /** Used to determine if a connection is open or not.
   */
  int fOpenConnection;

  /** The number of messages the user has waiting.
   */
  int fNumMsgs;

  ClientLocal *fClientLocal;
  ClientImap  *fClientImap;
  ClientPop3  *fClientPop3;
};

#endif
