#include "baseconfigdlg.h"
#include "resource.h"

#include <stdio.h> 

#include <qlabel.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <qgroupbox.h>

// KDE includes
#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>

CBaseConfigDlg::CBaseConfigDlg(QWidget* parent, const char* name) : QDialog(parent, name, FALSE)
{
  KConfig* config = kapp->getConfig();
  
  config->setGroup("BASE");

  // -- GROUP BOXES -----------------------------

  fGeneralTogglesGroupBox = new QGroupBox(i18n("General Toggles"), this, "GeneralTogglesGroupBox");
  fGeneralTogglesGroupBox->setGeometry(5, 10, 425, 50);

  fTimesGroupBox = new QGroupBox("Times", this , "TimesGroupBox");
  fTimesGroupBox->setGeometry(5, 65, 425, 108); 

  // -- END GROUP BOXES ---------------------------


  // -- STARTUP CHECKBOX ----------------------

  fStartup = new QCheckBox(this, "Startup");
  fStartup->setGeometry(20, 30, 115, 20);
  fStartup->setChecked(config->readBoolEntry("Startup", FALSE));
  fStartup->setText(i18n("Check at Startup"));

  // -- END STARTUP CHECKBOX ------------------

  // -- DOCK CHECHBOX -------------------------
  
  fDockOnLaunch = new QCheckBox(this, "DockOnLaunch");
  fDockOnLaunch->setGeometry(150, 30, 100, 20);
  fDockOnLaunch->setChecked(config->readBoolEntry("DockOnLaunch", FALSE));
  fDockOnLaunch->setText(i18n("Start Docked"));
  
  // -- END DOCK CHECKBOX ----------------------

  // -- START DOCKED CHECKBOX ------------------

  fNeverDisplaySplash = new QCheckBox(this, "NeverDisplaySplash");
  fNeverDisplaySplash->setGeometry(265, 30, 140, 20);
  fNeverDisplaySplash->setChecked(config->readBoolEntry("NeverDisplaySplash", FALSE));
  fNeverDisplaySplash->setText(i18n("Never Display Splash"));

  // -- END START DOCKED  CHECKBOX ----------------------
  

  // -- SLIDER ------------------

  fCheckTime = new QSlider(1, 30, 1, config->readNumEntry("CheckTime", 5), QSlider::Horizontal, this, "CheckTime");
  fCheckTime->setGeometry(70, 97, 300, 20);
  fCheckTime->setTickmarks(QSlider::Both);
  fCheckTime->setTracking(TRUE);
  fCheckTime->setTickInterval(1);
  
  fSliderCheckTimeValue = config->readNumEntry("CheckTime", 5);
  
  connect(fCheckTime, SIGNAL(valueChanged(int)), this, SLOT(slotCheckTimeChanged(int)));

  fStaticCheckTimeA = new QLabel(i18n("Mailboxes will be checked every "), this, "StaticCheckTime");
  fStaticCheckTimeA->setGeometry(70, 77, 190, 20);
  
  fCheckTimeValue = new QLabel(i18n("0"), this, "CheckTimeValue");
  slotCheckTimeChanged(config->readNumEntry("CheckTime", 5));
  fCheckTimeValue->setGeometry(260, 77, 15, 20);
  fCheckTimeValue->setAlignment(AlignCenter);

  fStaticCheckTimeB = new QLabel(i18n(" minute(s)."), this, "StaticCheckTime");
  fStaticCheckTimeB->setGeometry(275, 77, 80, 20);

  // -- END SLIDER --------------------

  // -- SLIDER -------------------------
  
  fTimeOutLength = new QSlider(1, 30, 1, config->readNumEntry("TimeOutLength", 8), QSlider::Horizontal, this, "TimeOutLength");
  fTimeOutLength->setGeometry(70, 145, 300, 20);
  fTimeOutLength->setTickmarks(QSlider::Both);
  fTimeOutLength->setTracking(TRUE);
  fTimeOutLength->setTickInterval(1);
  
  fSliderTimeOutLengthValue =  config->readNumEntry("TimeOutLength", 8);
  
  connect(fTimeOutLength, SIGNAL(valueChanged(int)), this, SLOT(slotTimeOutLengthChanged(int)));

  fStaticTimeOutLengthA = new QLabel(i18n("Socket will time out after "), this, "StaticTimeOutLength");
  fStaticTimeOutLengthA->setGeometry(70, 125, 140, 20);
  
  fTimeOutLengthValue = new QLabel(i18n("0"), this, "TimeOutLengthValue");
  slotTimeOutLengthChanged( config->readNumEntry("TimeOutLength", 8));
  fTimeOutLengthValue->setGeometry(210, 125, 15, 20);
  fTimeOutLengthValue->setAlignment(AlignCenter);

  fStaticTimeOutLengthB = new QLabel(i18n(" second(s) of inactivity."), this, "StaticTimeOutLength");
  fStaticTimeOutLengthB->setGeometry(225, 125, 140, 20);

  // -- END SLIDER ----------------------------------
  
}

CBaseConfigDlg::~CBaseConfigDlg()
{
  delete(fStartup);
  delete(fCheckTime);
  delete(fTimeOutLength);
  delete(fStaticCheckTimeA);
  delete(fStaticCheckTimeB);
  delete(fStaticTimeOutLengthA);
  delete(fStaticTimeOutLengthB);
  delete(fCheckTimeValue);
  delete(fTimeOutLengthValue);
  delete(fDockOnLaunch);
  delete(fNeverDisplaySplash);
  delete(fTimesGroupBox);
  delete(fGeneralTogglesGroupBox);
  
}

void CBaseConfigDlg::slotCheckTimeChanged(int value)
{
  char valueString[5];
  
  sprintf(valueString, "%d", value);
  fCheckTimeValue->setText(i18n(valueString));
  fCheckTimeValue->setAlignment(AlignCenter);
  
  fSliderCheckTimeValue = value;
}

void CBaseConfigDlg::slotTimeOutLengthChanged(int value)
{
  char valueString[5];
  
  sprintf(valueString, "%d", value);
  fTimeOutLengthValue->setText(i18n(valueString));
  fTimeOutLengthValue->setAlignment(AlignCenter);
  
  fSliderTimeOutLengthValue = value;
}

void CBaseConfigDlg::writeOptions()
{
  KConfig *config = kapp->getConfig();

 config->setGroup("BASE");

  config->writeEntry("Startup", fStartup->isChecked());
  config->writeEntry("DockOnLaunch", fDockOnLaunch->isChecked());
  config->writeEntry("CheckTime",  fSliderCheckTimeValue);
  config->writeEntry("TimeOutLength", fSliderTimeOutLengthValue);
  config->writeEntry("NeverDisplaySplash", fNeverDisplaySplash->isChecked());
}

#include "baseconfigdlg.moc"
