/************************************************************************
                          knetdump.h  -  description                              
                             -------------------                                     
    begin                : Mon Mar 29 14:39:40 CEST 1999
                                           
    copyright            : (C) 1999 by Norbert Weuster                         
    email                : weuster@uni-duisburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KNETDUMP_H
#define KNETDUMP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qfileinfo.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kprocess.h>

// application specific includes
#include "resource.h" 
#include "knetdumpdoc.h"
#include "ktrafficview.h" 
#include "kheaderview.h"
#include "kosiview.h" 
#include "kconf.h" 
#include "kchatview.h"
#include "kstatsview.h"

/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class KnetdumpView is
  * created which creates your view.
  */
class KnetdumpApp : public KTMainWindow {
  Q_OBJECT

  const char* tokenize( QString& token, const char *str, const char *delim);

public:
  /** construtor */
  KnetdumpApp(); 
  /** destructor */
  ~KnetdumpApp();
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
    * function */
  void initToolBar();
  void initStatsToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the mainview*/
  void initView(const int name);
  /** save the app-specific options on slotAppExit or by an Options dialog */
  void saveOptions();
  void saveMyOptions();
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();
  void readMyOptions();
  /** enable menuentries/toolbar items */
  void enableCommand(int id_);
  /** disable menuentries/toolbar items */
  void disableCommand(int id_);
  /** overloaded for Message box on last window exit */
  bool queryExit();

public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** starts help for file name and chapter chapter **/
  void slotHTMLHelp(char *, char *);
  /** open a new application window */
  void slotFileNewWindow();
  /** close the current window */  
  void slotFileCloseWindow();
  /** exits the application */
  void slotFileQuit();

  /** Starts Application KSniffer **/
  void slotViewKsniffer();
  /** Starts Application KChatView **/
  void slotViewChat();
  /** Starts Application KStatsView **/
  void slotViewStats();
  /** Starts Application KTrafficView **/
  void slotViewTraffic();
  /** Starts Application KHeaderView **/
  void slotViewHeader();
  /** Starts the basic descriptions **/
  void slotViewOSI();
  /** Starts the configuration dialog **/
  void slotOptionConf();
  /** Deletes the ARP table entry **/
  void slotOptionDARP(); 
  /** Clears the statistics of the devices **/
  void slotOptionCSTATS(); 
  /** Deletes all stored packets   **/
  void slotOptionDPacket();


  /** Pause the sniffing process in doc **/
  void slotPauseDoc();
  /** Start the sniffing process in doc **/
  void slotProceedDoc();
  /* after receiving signal startedDoc, set the pause_button active, proceed inactive */
  void slotDocIsStarted();
  /* after receiving signal pausedDoc, set the proceed_button active, pause inactive */
  void slotDocIsPaused();
  /* after receiving signal stoppedDoc, set the proceed_button and pause_button inactive */
  void slotDocIsStopped();
  /** toggle the toolbar*/
  void slotViewToolBar();
  //void slotViewStatsToolBar();
  /** shows toolbar for KstatsView **/
  void showStatsToolBar();	
  /** hides toolbar for KstatsView **/
  void hideStatsToolBar();
  /** toggle the statusbar*/
  void slotViewStatusBar();
  /** change the status message to text */
  void slotStatusMsg(const char *text);
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);

private slots:
 // if an item in the InterfaceCombo is changed, it will call:
 void slotChangeComboInterface(int);
 // if the interfaces changed, fill the StatsCombo */
 QString fillStatsCombo();

signals:
    void slotChangeInterface(QString); 

private:
  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
  /** option_menu contains all items of the menubar entry "Options" */
  QPopupMenu *option_menu;
  /** view_menu contains all items of the menubar entry "View" */
  QPopupMenu *view_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */

  /* pointer to the KTrafficView */
  KTrafficView *pKTrafficView;
  /* pointer to the KHeaderView */
  KHeaderView *pKHeaderView;
  /* pointer to the KChatView */
  KChatView *pKChatView;
  /* pointer to the KStatsView */
  KStatsView *pKStatsView;
  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
  KnetdumpDoc *pdoc;
  /* pointer to the KOsiView-class, the documentation */
  KOsiView *pKOsiView;
  /* pointer to the KConf(ig)-class */
  KConf *pKConf;
  
  /** flag if toolbar is visible or not. Used for kconfig and checking the
    * view-menu entry view toolbar. bViewStatusbar does the same for the
    * statusbar.
    */
  bool bViewToolbar;
  bool sViewToolbar;
  bool bViewStatusbar;
  /* flag if a welcome screen appears on startup */
  bool welcome;
  /** used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should add
    * positions as well and implement them in saveOptions() and readOptions().
    */
  KMenuBar::menuPosition menu_bar_pos;
  KToolBar::BarPosition tool_bar_pos;
  
  /* stores the active view */
  view_active active_view;
};   
 
#endif // KNETDUMP_H

