/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                :  Mo Jun 7 1999
    copyright            : (C) YEAR by 1999 by Norbert Weuster
    email                : weuster@uni-duisburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KCHATVIEW_H
#define KCHATVIEW_H

#include <qwidget.h>
#include <kapp.h>
#include <qtimer.h>
#include <qframe.h>
#include <qscrollview.h>
#include <qmessagebox.h>
#include <qpainter.h>
#include <kmsgbox.h>
#include <string>
#include <unistd.h>
#include <netinet/tcp.h>
#include "knetdumpdoc.h"
#include "KChatViewData.h"
#include "khostselection.h"
#include <qlayout.h>

/**
  *@author Norbert Weuster
  */

class KChatView : public KChatViewData {
    Q_OBJECT
public: 
    KChatView(QWidget *parent, KnetdumpDoc *doc, const char *name=0);
    virtual ~KChatView();
    
public slots:
   void startslot();   
   void showslot();
   void slotResetIP(); 
   virtual void paintEvent (QPaintEvent*);
   virtual void contentsMove(int,int);
   virtual void viewportMousePressEvent ( QMouseEvent * );
   virtual void mousePressEvent ( QMouseEvent * );
   virtual void eventfilter (QObject * obj, QEvent * e );

signals:
   void gotData();
   void fetchPacket(int);

private: 
   void selectDraw();
   void drawChat();
   void drawTCP(QPainter &p);
   void drawARP(QPainter &p);
   void setHosts();
   void setUpFilter();

private:
   KnetdumpDoc *pdoc;
   QWidget *pChatWidget;

   QWidget *LeftWidget;
   QWidget *RightWidget;
   
   bool drawing;
   bool newpacket;
   QTimer *drawTimer;
   QPixmap pm;
  
   int y;
   int xLeft;
   int xRight;
        
   QString saddr;      
   QString daddr;
   QString sEther;
   QString dEther;
    
   QString hostnameA;
   QString hostnameB;

};

#endif












