/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : Mo Jun 7 1999
    copyright            : (C) 1999 by Norbert Weuster
    email                : weuster@uni-duisburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kchatview.h"
#define Inherited KChatViewData

KChatView::KChatView(QWidget *parent, KnetdumpDoc *doc, const char *name ): Inherited( parent, name ), pdoc(doc) {
   // an update timer for the widget
    drawTimer = new QTimer(  this );
    connect( drawTimer, SIGNAL(timeout()), SLOT(update()) );   
    // set host A&B with dialog CHATselection
    setHosts();
    // setup the filter in pdoc
    setUpFilter();

    drawing=false;
    newpacket=false;

    // create the draw-widget in the scrollview
    pChatWidget = new QWidget(ScrollView_1->viewport(), "ChatFrame");
    pChatWidget->resize(ScrollView_1->width(),44*pdoc->getPacketMax());
    ScrollView_1->resizeContents(ScrollView_1->width(),44*pdoc->getPacketMax());
       
    setEnabled(true);
    ScrollView_1->setEnabled(true);
    pChatWidget->setEnabled(true);

    ScrollView_1->addChild(pChatWidget);
    ScrollView_1->showChild(pChatWidget);

}

KChatView::~KChatView() {
    delete (drawTimer);
}

void KChatView::startslot () {  // slot for newPackets
    // newPacket realized, if it is 1 of our ip, notice in "newpacket",
    // inform pdoc
    if ((pdoc->gethostname_from(saddr) != hostnameA && pdoc->gethostname_to(daddr) != hostnameA) 
        || (pdoc->gethostname_from(saddr) != hostnameB && pdoc->gethostname_to(daddr) != hostnameB)) {
        emit gotData();
        return;
    }
    newpacket=true;
    emit gotData();

    // start drawChat, to view: oldPackets + the new one
    if (!drawing)
        drawChat();
}

void KChatView::showslot() {    // slot for oldPackets
    // get only packets between hostnameA and hostnameB
    if ((pdoc->gethostname_from(saddr) != hostnameA && pdoc->gethostname_to(daddr) != hostnameA) 
        || (pdoc->gethostname_from(saddr) != hostnameB && pdoc->gethostname_to(daddr) != hostnameB)) {
        emit gotData();
        return;
    }

    // devide between ARP and TCP in:
    selectDraw();
}

void KChatView::drawChat () {
    if (drawing) return;
    drawing = true;
    
    drawTimer->stop();
    // resize widgets
    pChatWidget->resize(ScrollView_1->width(),44*pdoc->getPacketMax());
    ScrollView_1->resizeContents(ScrollView_1->width(),44*pdoc->getPacketMax());
    
    // setup paint region
    QRect r=pChatWidget->geometry();
    pm.resize(r.size());
    pm.fill(pChatWidget, r.bottomLeft());   
    y=30;

    // get each packet
    for (unsigned int i=0; i<pdoc->getPacketNum(); i++) {
        emit fetchPacket(i);
    }

    // set scrollbar
    if (newpacket) {
        if ( y >= (ScrollView_1->height()*2/3 )) 
            ScrollView_1->center(ScrollView_1->x(),y);
        else 
            ScrollView_1->center(ScrollView_1->x(),0);
        newpacket=false;
    }
    
    // (erase old widget and) build up the new widget
    //pChatWidget->erase();
    bitBlt( pChatWidget, 0, 0, &pm); 
    drawing = false;
    
    // restart the update timer
    drawTimer->start( pdoc->getUpdateTime(), TRUE );     // single-shot
}

void KChatView::paintEvent (QPaintEvent*) {
    //
    // Draw current status
    //
    if (drawing) return;
    // drawing = true;

    // set the X-coordinate, where we have to draw
    xLeft=pChatWidget->x()+5;
    xRight=pChatWidget->width()-25;
    
    // draw all packets
    drawChat();
} 

void KChatView::selectDraw () {   // devide between IP/ARP
    QPainter p;

    switch (pdoc->getNetwProtocol()) {
    case ETHERTYPE_IP: {
        register struct iphdr *ip= (struct iphdr *) pdoc->getpNetwLayer();
        if (ip->protocol==IPPROTO_TCP) {
            p.begin(&pm);
            drawTCP(p);
        }
        break;
    }
    case ETHERTYPE_ARP:
    case ETHERTYPE_REVARP: {
        const struct arphdr *arp= (struct arphdr *)pdoc->getpNetwLayer();
        register u_char *pp= (u_char *) arp + sizeof(arphdr);
        register short unsigned int count;
        register QString str;

        // set MAC addresses
        if (ntohs(arp->ar_pro) == ETHERTYPE_IP) {
            sEther= "";
            for (count=arp->ar_hln; count>0; count--) {
                str.sprintf("%02x:", *pp++);
                sEther += str;
            }
            pp += arp->ar_pln;

            dEther= "";
            for (count=arp->ar_hln; count>0; count--) {
                str.sprintf("%02x:", *pp++);
                dEther += str;
            }

            p.begin(&pm);
            drawARP(p);
        }
        else {
            emit gotData();
            return;
        }
        break;
    }                             
    default:
        // noTCP/noARP
        emit gotData();
        return;
        break;
    }

    p.end();
    emit gotData();
}
    
void KChatView::drawTCP (QPainter &p) {
    int x1,x2;
    float alpha=0;
    QString over, under, flags, port;

    const struct tcphdr tcp= *((struct tcphdr *) pdoc->getpTranspLayer());        

    // decide arrow-direction
    if (saddr==hostnameA) {
        alpha=1.0;
        x1=xLeft;
        x2=xRight;
    }
    else {
        alpha=-1.0;
        x1=xRight;
        x2=xLeft;
    }
    // p.rotate(alpha);
    // draw arrow (line)
    QPen pen (darkYellow,3);
    p.setPen(pen);
    p.drawLine(x1,y,x2,y);
    // draw pike
    p.drawLine(x2, y, (x2>x1) ? (x2-7) : (x2+7), y-5); 
    p.drawLine(x2, y, (x2>x1) ? (x2-7) : (x2+7), y+5);
    //pen.setWidth(1);
    p.setPen(black);
    // draw text over/under the line:
    flags="   flags:";
    if (tcp.fin) {
        flags += 'F';
        p.setPen(red);
    }
    if (tcp.syn) {
        flags += 'S';
        p.setPen(darkGreen);
    }
    if (tcp.rst) {
        flags += 'R';
        p.setPen(red);
    }
    if (tcp.psh)
        flags += 'P';
    if (tcp.ack)
        flags += 'A';		
    if (tcp.urg)
        flags += 'U';
    port.sprintf("      destination-port: %u", ntohs(tcp.dest));
    over.sprintf ("seq: %u     ", ntohl(tcp.seq));
    over += flags;
    over += port;
    p.drawText(xLeft+20,y-6, over);
    under.sprintf("ack: %u     winsize:%u     source-port:%u", ntohl(tcp.ack_seq), ntohs(tcp.window), ntohs(tcp.source));
    p.drawText(xLeft+20,y+14, under);
    alpha*=(-1);
    // p.rotate(alpha);
    y+=40; 

}

void KChatView::drawARP(QPainter &p) {
    int x1,x2;
    float alpha=0;
    QString over, under, option;
    char marker1=' ';
    char marker2=' ';
    
    // get the arp-operation
    unsigned short int arpOption =((struct arphdr *) pdoc->getpNetwLayer())->ar_op;
    // set X- and Y-coordinate
    if (saddr==hostnameA) {
        alpha=1.0;
        x1=xLeft;
        x2=xRight;
    }
    else {
        alpha=-1.0;
        x1=xRight;
        x2=xLeft;
    }

    // p.rotate(alpha);

    // draw arrow (line)
    QPen pen (darkGreen,3);
    p.setPen(pen);
    p.drawLine(x1,y,x2,y);

    // draw pike
    p.drawLine(x2, y, (x2>x1) ? (x2-7) : (x2+7), y-5); 
    p.drawLine(x2, y, (x2>x1) ? (x2-7) : (x2+7), y+5);

    // draw text over/under the line:
    //pen.setWidth(1);
    p.setPen(black);
    switch (ntohs(arpOption)) {
         case 1:
        option +="ARP request";
        marker2 = '?';
        break;
    case 2:
        option +="ARP reply";
        marker1 = '!';
        break;
    case 3:
        option +="RARP-request";
        marker2 = '?';
        break;
    case 4:
        option +="RARP-reply";
        marker1 = '!';
        break;
    default:
        option.sprintf("op:", ntohs(arpOption));
        break;
    }
    over.sprintf ("Source-IP:%s  has  MAC:%s %c", (const char *)saddr, (const char *)sEther, marker1);
    p.drawText(xLeft+20,y-6, over);
    under.sprintf("Destination-IP:%s  has  MAC:%s %c ",  (const char *)daddr,  (const char *)dEther, marker2);
    p.drawText(xLeft+20,y+14, under);
    alpha*=(-1);
    // p.rotate(alpha);

    // set Y to the next line
    y+=40; 
}

void KChatView::slotResetIP() {
    // if packets and nodes are deleted, the nodes have to be re-set
    setUpFilter();
    drawing=false;
    newpacket=false;
}


void KChatView::setHosts() {
    // start a dialog to select hosts
    KHostSelection hostSelect(hostnameA, hostnameB,  this, "HostSelection");
    hostSelect.exec();

    // setup text of label in view
    QString a,b;
    a.sprintf("%s\n%s\n", i18n("Host A"), (const char *)hostnameA);
    b.sprintf("%s\n%s\n", i18n("Host B"), (const char *)hostnameB);
    LeftLabel->setText(a);
    RightLabel->setText(b);
}

void KChatView::setUpFilter() {
    // format:
    //    setFilter(bool IEEE802    , bool rARP, bool rIP, bool rTCP, bool rUDP, bool rICMP,   int rPort  );
    pdoc->setFilter(pdoc->recIEEE802,    true  ,   true  ,  true    ,  false   ,   false   , false, pdoc->recPort);
    
    // receive no new Node
    pdoc->setSelectNode(false);  

    // create nodes if neccessary
    pdoc->storeNode(hostnameA);
    pdoc->storeNode(hostnameB);

    // deselect all nodes
    for (int i=pdoc->getNodeNum()-1; i>=0; i--) 
        pdoc->setNodeSelected((const char *) pdoc->getNode(i),false);
    
    // select the two desired nodes
    pdoc->setNodeSelected(hostnameA, true);
    pdoc->setNodeSelected(hostnameB, true);
}

void KChatView::contentsMove(int,int) {
    repaint();
}

void KChatView::viewportMousePressEvent(QMouseEvent *e) {
    cerr << "viewportMousePressEvent: mouse was pressed " << " " << " " << endl;
    if ( e->button() != LeftButton )
        return;
}

void KChatView::mousePressEvent( QMouseEvent *e) {
    cerr << "mousePressEvent: mouse was pressed " << " " << " " << endl; 
}

void KChatView::eventfilter (QObject * obj, QEvent * e ){
    cerr << "eventfilter: " << " " << " " << endl; 
}


