/***************************************************************************
                          voicedial.cpp  -  description
                             -------------------
    begin                : Wed Jan 5 2000
    copyright            : (C) 2000 by Torsten Uhlmann
    email                : TUhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define HAVE_SGI_STL

#include <qmessagebox.h>
#include <qbuttongroup.h>
#include <qregexp.h>

//#include <stl_headers.h>
#include <kapp.h>
#include <kabapi.h>

#include "voicedial.h"

VoiceDial::VoiceDial(KMsgModemApp *app, USRModem *modem, QWidget *parent, const char *name) : QDialog(parent,name,false){
	initDialog();

	_app = app;
	_modem = modem;

	connect( closeButton					, SIGNAL(clicked()), SLOT(slotCloseDialog()) );
	connect( no_0_Button					, SIGNAL(clicked()), SLOT(slotNo_0_Dialed()) );
	connect( no_1_Button					, SIGNAL(clicked()), SLOT(slotNo_1_Dialed()) );
	connect( no_2_Button					, SIGNAL(clicked()), SLOT(slotNo_2_Dialed()) );
	connect( no_3_Button					, SIGNAL(clicked()), SLOT(slotNo_3_Dialed()) );
	connect( no_4_Button					, SIGNAL(clicked()), SLOT(slotNo_4_Dialed()) );
	connect( no_5_Button					, SIGNAL(clicked()), SLOT(slotNo_5_Dialed()) );
	connect( no_6_Button					, SIGNAL(clicked()), SLOT(slotNo_6_Dialed()) );
	connect( no_7_Button					, SIGNAL(clicked()), SLOT(slotNo_7_Dialed()) );
	connect( no_8_Button					, SIGNAL(clicked()), SLOT(slotNo_8_Dialed()) );
	connect( no_9_Button					, SIGNAL(clicked()), SLOT(slotNo_9_Dialed()) );
	connect( deleteButton					, SIGNAL(clicked()), SLOT(slotDeleteNumber()) );
	connect( deleteDigitButton		, SIGNAL(clicked()), SLOT(slotDeleteDigit()) );
	connect( setPreferencesButton	, SIGNAL(clicked()), SLOT(slotSetPreferences()) );
	connect( searchAddressbookButton	, SIGNAL(clicked()), SLOT(slotSearchAddressbook()) );

	connect( speakerVolume				, SIGNAL(	valueChanged(int)),
																	speakerVolumeLCD, SLOT(display(int)));
	connect( mikeVolume						, SIGNAL(	valueChanged(int)),
																	mikeVolumeLCD, SLOT(display(int)));

	bGroup = new QButtonGroup();
	bGroup->insert(dialPrefixCheck);	
	connect( bGroup, SIGNAL(clicked(int)), SLOT(slotDialPrefixStateChanged(int)) );

	// set Dial Button
	dialHangupButton->setText(i18n("Dial"));;
	connect( dialHangupButton	, SIGNAL(clicked()), SLOT(slotDialNumber()) );
																		
	slotDialogInit();		
}

VoiceDial::~VoiceDial(){
	saveOptions();
}

void VoiceDial::slotCloseDialog()
{
	saveOptions();
	hide();
}

void VoiceDial::saveOptions()
{
	//create separate object that handles configurable values
  KConfig *config = kapp->getConfig();

  config->setGroup("DIAL");
  config->writeEntry("UseDialPrefix"	,	dialPrefixCheck->isChecked());
  config->writeEntry("DialPrefix"			,	dialPrefix->text());
}

void VoiceDial::slotDialogInit()
{
	slotDeleteNumber();
	slotGetPreferences();
}

void VoiceDial::slotNo_0_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("0");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotNo_1_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("1");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotNo_2_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("2");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotNo_3_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("3");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotNo_4_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("4");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotNo_5_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("5");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotNo_6_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("6");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotNo_7_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("7");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotNo_8_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("8");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotNo_9_Dialed()
{
	QString	_dialNumber = dialNumber->text();
	_dialNumber.append("9");
	dialNumber->setText(_dialNumber.data());
}

void VoiceDial::slotDeleteNumber()
{
	dialNumber->setText("");
}

void VoiceDial::slotDeleteDigit()
{
	QString number = dialNumber->text();
	if (!number.isEmpty())
	number.remove(number.length()-1,1);
	dialNumber->setText(number.data());
}

void VoiceDial::slotDialNumber()
{
	QString	_dialNumber = dialNumber->text();
	if (_dialNumber.isEmpty())
	{
	   QMessageBox::information(0,i18n("Dial Number"),
      i18n("You need to give a number to dial!"),
   	  QMessageBox::Ok | QMessageBox::Default);
	 	return;
	}
	//generateValidNumber(_dialNumber);
	_modem->dialVoiceNumber(generateValidNumber(_dialNumber));
	
	// set Dial Button as HangupButton
	disconnect( dialHangupButton	, SIGNAL(clicked()), this, SLOT(slotDialNumber()) );
	dialHangupButton->setText(i18n("Hangup"));;
	connect( dialHangupButton	, SIGNAL(clicked()), SLOT(slotHangupPhone()) );
}

void VoiceDial::slotHangupPhone()
{
	_modem->hangupPhone();
	
	// set Dial Button as Dial Button
	disconnect( dialHangupButton	, SIGNAL(clicked()), this, SLOT(slotHangupPhone()) );
	dialHangupButton->setText(i18n("Dial"));;
	connect( dialHangupButton	, SIGNAL(clicked()), SLOT(slotDialNumber()) );
}

void VoiceDial::slotSetPreferences()
{
	int speaker = speakerVolumeLCD->intValue();
	int mike		= mikeVolumeLCD->intValue();
	debug("setting speaker / mike: %d / %d",speaker,mike);
	_modem->setSpeakerMikeVolume(speaker,mike);
}

void VoiceDial::slotGetPreferences()
{
	int speaker = 0;
	int mike		= 0;
	if (_modem->getSpeakerMikeVolume(speaker,mike))
	{
		speakerVolume->setValue(speaker);
		mikeVolume->setValue(mike);
	}

	// Get prefs from config file	
  KConfig *config = kapp->getConfig();

  config->setGroup("DIAL");
  dialPrefixCheck->setChecked(config->readBoolEntry("UseDialPrefix", false));
  dialPrefix->setText(config->readEntry("DialPrefix", "0"));

	if (dialPrefixCheck->isChecked())
		dialPrefix->setEnabled(true);
	else
		dialPrefix->setEnabled(false);
}

void VoiceDial::slotSearchAddressbook()
{
	KabAPI kabapi(this);
	if(kabapi.init()!=KabAPI::NoError)
	{
		QMessageBox::information(0,i18n("Addressbook"),
      i18n("Addressbook KAB could not be started!"),
   	  QMessageBox::Ok | QMessageBox::Default);
	 	return;
	}
	AddressBook::Entry entry;
	string key;
	if(kabapi.exec())
	{
		if(kabapi.getEntry(entry,key)!=KabAPI::NoError)
		{
			QMessageBox::information(0,i18n("Addressbook"),
      	i18n("Addressbook KAB is empty!"),
   	  	QMessageBox::Ok | QMessageBox::Default);
		 	return;
		} else {
			dialNumber->setText(entry.telephone.c_str());
		}
	}

}

QString VoiceDial::generateValidNumber(const QString &number)
{
	QString validNumber = number.copy();
	validNumber.replace( QRegExp("[^0-9]"), "" );
	debug("Number is now: %s",validNumber.data());
	// should we use prefix
	if (dialPrefixCheck->isChecked()) {
		validNumber = dialPrefix->text() + validNumber;
	}
	debug("Number is now: %s",validNumber.data());
	return validNumber;
}

void VoiceDial::slotDialPrefixStateChanged(int id)
{
	switch(id)
	{
		case 0:
			if (dialPrefixCheck->isChecked())
				dialPrefix->setEnabled(true);
			else
				dialPrefix->setEnabled(false);
			break;
		default: break;
	}
}
