/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <o.gantz@tu-bs.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef PREVIEW_H
#define PREVIEW_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <X11/Xlib.h>
#undef TrueColor	// Avoid Qt <-> X11 conflict

#include <qwidget.h>
#include <qevent.h>
#include <qscrollbar.h>

#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>

#include "mlofile.h"




class FaxWidget : public QWidget
{
	Q_OBJECT
public:
	FaxWidget( QWidget * parent = 0, const char * name = 0, WFlags f = 0 );
	~FaxWidget();

	void setImage( int w, int h, char * data );
	void deleteImage();

	void x11EventFilter( XEvent * ev );

	Window window;

public slots:
	void setXScroll( int x );
	void setYScroll( int y );

signals:
	void move( int, int );

protected:
	virtual void paintEvent( QPaintEvent * );

private:
	int scrollx, scrolly;

	Display * display;
	GC gc;
	XImage * image;
	int im_width, im_height;
	Cursor move_cursor;
	bool moving;
	int move_x, move_y;
};


extern FaxWidget * fw;



class Preview : public QWidget
{
	Q_OBJECT
public:
	Preview( QWidget * parent = 0, const char * name = 0, WFlags f = 0 );
	~Preview();

	void showFax( const char * name, const char * alias );

	virtual void show();

public slots:
	virtual void hide();

private:
	void deletePages();
	void showPage();
	void loadPage( int p );

private slots:
	void printFile();
	void mailFile();

	void firstPage();
	void prevPage();
	void nextPage();
	void lastPage();

	void zoomIn();
	void zoomOut();

	void toggleToolbar();
	void toggleStatusbar();

	void moveSlot( int x, int y );

protected slots:
	virtual void updateRects();

protected:
	virtual void resizeEvent( QResizeEvent * );
	void keyPressEvent( QKeyEvent * );

private:
	char * fname, * salias;
	MLOFile file;

	char * page_datas[3];
	int page, pages;
	int page_width, page_height;
	int zoom_width, zoom_height;
	int zoom;

	KMenuBar * menuBar;
	int menu_item_prev;
	int menu_item_next;
	int menu_item_first;
	int menu_item_last;
	int menu_item_zoomin;
	int menu_item_zoomout;
	int menu_item_tool;
	int menu_item_status;
	KToolBar * toolBar;
	bool toolBarOn;
	FaxWidget * view;
	QScrollBar * hscroll, * vscroll;
	KStatusBar * statusBar;
	bool statusBarOn;
};


#endif // PREVIEW_H
