/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <o.gantz@tu-bs.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef DOWNLOADDLG_H 
#define DOWNLOADDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qprogressdialog.h>
#include <qwidget.h>

#include "modem.h"



typedef struct fitem {
	char name[19];
	char time[18];
	int size;
	bool saved;
	struct fitem * next;
} fitem_t;



class DownloadDlg : public QProgressDialog
{
	Q_OBJECT
public:
	DownloadDlg( QWidget * parent = 0, const char * name = 0, bool modal = FALSE, WFlags f = 0 );
	~DownloadDlg();

	bool startDownload( const char * device, int speed );

public slots:
	void cancel();

private slots:
	void fetchModemLine( const char * line );
	void fetchXModemBlock( const uchar * block, int size );
	void fetchXModemDone( bool success );
	void fetchTimeout();

private:
	void init();
	void reset();
	void downloadFile();

	Modem * modem;
	int status;

	fitem_t * fitems;
	int nfiles, count;

	int fd;

	char msgbuff[40];

signals:
	void message( const char * );
	void gotFile( const char *, const char *, int );
	void done();
};


#endif // DOWNLOADDLG_H
