#include <sys/sysinfo.h>
#include <errno.h>

#include <qobject.h>

#include "meminfo.h"

MemInfo::MemInfo(QWidget *parent, const char *name)
	: QObject(parent, name)
{
	updateInfo() ;
}

MemInfo::~MemInfo() {}

struct sysinfo* MemInfo::info = new struct sysinfo ;

void MemInfo::updateInfo()
{
	int result = sysinfo( MemInfo::info ) ;
	
	if ( result==-1 )
		printf("MemInfo: error while calling sysinfo (errno %d)\n",
				errno ) ;
}

unsigned long MemInfo::getTotalMem()
{
	return info->totalram + info->totalswap ;
}

unsigned long MemInfo::getTotalRam()
{
	return info->totalram ;
}

unsigned long MemInfo::getFreeRam()
{
	return info->freeram ;
}

unsigned long MemInfo::getBufferRam() 
{
	return info->bufferram ;
}
unsigned long MemInfo::getSharedRam() 
{
	return info->sharedram ;
}

unsigned long MemInfo::getTotalSwap() 
{
	return info->totalswap ;
}
unsigned long MemInfo::getFreeSwap()
{
	return info->freeswap ;
}



