/**********************************************************************
**
** $Id: kintegerline.cpp,v 1.3 1998/06/01 08:42:43 kalle Exp $
**
** Implementation of 
**
** Copyright (C) 1997 Michael Wiedmann, <mw@miwie.in-berlin.de>
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the Free
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
*****************************************************************************/

#include "myintegerline.h"
#include <qkeycode.h>

#include <stdlib.h>


MyIntegerLine::MyIntegerLine( int value, QWidget *parent,
			const char *name, KEditLineType t)
{
	MyIntegerLine( parent, name, t ) ;

	setValue(value) ;
}

MyIntegerLine::MyIntegerLine( QWidget *parent,
							const char *name,
							KEditLineType t)
  : KRestrictedLine( parent, name, "0123456789" ),
	use_max(false), use_min(false)
{
  switch (lineType = t)
    {
    case KEditTypeOct:
      setValidChars("01234567");
      break;
      
    case KEditTypeHex:
      setValidChars("0123456789ABCDEFabcdef");
      break;

    default:
      break;
    }

  connect( this, SIGNAL( textChanged( const char* ) ),
		   this, SLOT( internalValueChanged() ) );

   setMinimumValue( 0, true ) ;
}

MyIntegerLine::MyIntegerLine()
  : KRestrictedLine()
{
  ;
}

MyIntegerLine::~MyIntegerLine()
{
  ;
}

KEditLineType MyIntegerLine::getType()
{
  return (lineType);
}

int MyIntegerLine::maximumValue()
{
	return max_value ;
}

int MyIntegerLine::minimumValue()
{	return min_value ;
}

bool MyIntegerLine::useMaximum() { return use_max ; }

bool MyIntegerLine::useMinimum() { return use_min ; }		

void MyIntegerLine::setMaximumValue( int v, bool use )
{
	use_max=use;
	max_value=v;

}

void MyIntegerLine::setMinimumValue( int v, bool use )
{
	use_min=use ;
	min_value=v;
}

int MyIntegerLine::value( void )
{
  QString s = text();
  return getValue( s );
}


void MyIntegerLine::setValue( int value )
{
 if ( use_min && value<min_value )
	value = min_value ;
 if ( use_max && value>max_value )
	value = max_value ;
  putValue( value );
}

 
void MyIntegerLine::keyPressEvent( QKeyEvent *e )
{
  switch(e->key())
    {
    case Key_Up:
      setValue( value()+1 ) ;
      break;
      
    case Key_Down:
      setValue( value()-1 ) ;
      break;
      
    case Key_Prior:
      incValue(value());
      break;
            
    case Key_Next:
      decValue(value());
      break;
      
    default: // switch (e->key())
      KRestrictedLine::keyPressEvent(e);
      break;
    }
  
  return;
}


int MyIntegerLine::getValue(QString &s)
{
  return (strtol(s, 0, (int)lineType));
}

void MyIntegerLine::putValue(int val)
{
  QString s ;
  switch (lineType)
    {
	case  KEditTypeOct:
	  s.sprintf("%o", val);
	  break;
       
	case  KEditTypeDec:
	  s.sprintf("%d", val);
	  break;

	case  KEditTypeHex:
	  s.sprintf("%X", val);
	  break;
    }
  setText(s);
}

void MyIntegerLine::incValue(int val)
{
  QString s ;

  switch (lineType)
    {
	case  KEditTypeOct:
	  val += 8;
	  break;
       
	case  KEditTypeDec:
	  val += 10;
	  break;

	case  KEditTypeHex:
	  val +=16;
	  break;
    }
  setValue( val ) ;
}

void MyIntegerLine::decValue(int val)
{
  switch (lineType)
    {
	case  KEditTypeOct:
	  val -= 8;
	  break;
       
	case  KEditTypeDec:
	  val -= 10;
	  break;

	case  KEditTypeHex:
	  val -= 16;
	  break;
    }
  setValue( val ) ;
}


void MyIntegerLine::internalValueChanged()
{
  emit valueChanged( value() );
}
