/*
	This file is part of `klp', a KDE Line Printer queue manager

	Copyright (C) 1998
	Frans van Dorsselaer
	<dorssel@MolPhys.LeidenUniv.nl>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include <qlist.h>

#include <kapp.h>

#include "queuebox.h"
#include "inter.h"


static int rank_sort(const char *s1, const char *s2)
{
	char *p;
	int i1;
	int i2;

	i1 = strtoul(s1, &p, 10);
	if (p == s1)
		i1 = 0;
	i2 = strtoul(s2, &p, 10);
	if (p == s2)
		i2 = 0;
	return i1 - i2;
}


QueueBox::QueueBox(QWidget *parent) : KTabListBox(parent, NULL, 4)
{
	setColumn(0, i18n("Rank"), 50, KTabListBox::TextColumn,
		KTabListBox::SimpleOrder, KTabListBox::Descending,
		false, rank_sort);
	setColumn(1, i18n("User"), 80, KTabListBox::TextColumn,
		KTabListBox::SimpleOrder, KTabListBox::Descending);
	setColumn(2, i18n("Document"), 160, KTabListBox::TextColumn);
	setColumn(3, i18n("Size"), 50, KTabListBox::TextColumn);
	enableKey();
	queue_item_list.setAutoDelete(true);
}


void QueueBox::setQueueItemList(QueueItemList *new_list)
{
	if (!new_list) {
		if (count()) {
			setAutoUpdate(false);
			clear();
			queue_item_list.clear();
			setAutoUpdate(true);
			repaint();
		}
		return;
	}

	QueueItem *old_item;
	QueueItem *new_item;

	new_list->setAutoDelete(true);

	if (new_list->count() == queue_item_list.count()) {
		for (new_item = new_list->first() , old_item = queue_item_list.first()
				; new_item && old_item
				; new_item = new_list->next() , old_item = queue_item_list.next())
			if ((old_item->rank != new_item->rank)
					|| (old_item->user != new_item->user)
					|| (old_item->job_name != new_item->job_name)
					|| (old_item->size != new_item->size))
				break;
		if (!new_item && !old_item)
			return;
	}
	setAutoUpdate(false);
	clear();
	queue_item_list.clear();
	while (new_list->count()) {
		new_item = new_list->take(0);
		queue_item_list.append(new_item);
		QString s;
		if (new_item->rank)
			s = QString().setNum(new_item->rank);
		else
			s = i18n("active");
		s += "\n" + new_item->user + "\n" + new_item->job_name + "\n" + QString().setNum(new_item->size);
		appendItem(s);
	}
	reorderRows();
	setAutoUpdate(true);
	repaint();
	delete new_list;
}


bool QueueBox::haveOwnedJob()
{
	QueueItem *item;
	bool r = false;
	
	for (item = queue_item_list.first() ; item ; item = queue_item_list.next())
		if (item->user == username) {
			r = true;
			break;
		}
	return r;
}


#include "queuebox.moc"
