#include "kldap.h"
#include <stdio.h>

const char *ldap2english[][2] = {
    {	"Name", 		"cn" },
    { 	"Email", 		"mail"},
    { 	"Home Phone", 		"homephone"},
    { 	"Business Phone",	"businessphone"},
    { 	0, 		0 }
};

int 
KLdap::msgfree(LDAPMessage *m)
{
		return ldap_msgfree(m);
}

void
KLdap::value_free(char **v)
{
		ldap_value_free(v);
}

KLdapEntry * 
KLdap::firstEntry()
{
		e = ldap_first_entry(ld, res);
		if (e != NULL)
				return (new KLdapEntry(ld, e));
		else
				return NULL;
}

KLdapEntry * 
KLdap::nextEntry()
{
		e = ldap_next_entry(ld, e);
		if (e != NULL)
				return (new KLdapEntry(ld, e));
		else
				return NULL;
}

int
KLdap::simple_bind_s(char *who, char *passwd)
{
		return ldap_simple_bind_s(ld, who, passwd);
}

int
KLdap::lookup(const char *s)
{
	char *buf;

	buf = new char[(strlen(s) + 10)];

	if (!buf) {
		perror("out of memory\n");
		return -1;
	}

	sprintf(buf, "(cn=%s)", s);

	/* search for entries with cn of "Babs Jensen",
	   return all attrs  */
	if (ldap_search_s("",
					  LDAP_SCOPE_SUBTREE, buf, NULL, 
					  0)
		!= LDAP_SUCCESS ) {
		delete buf;
		return -1;
	}

	delete buf;
	return 0;
}

char *
KLdapEntry::getField(const char *s)
{
	int i, n;
	char **vals;

	n = sizeof(ldap2english)/sizeof(ldap2english[0]);

	for (i = 0; i < n; i++)
		if (strcmp(ldap2english[i][0], s) == 0) 
			break;

	if (i == n)
		return NULL;
			
	vals = getValues(ldap2english[i][1]);

	if (!vals)
		return NULL;

	// XXX: Fix leak
	return vals[0];
}
