// 
// 
// Class Declaration for LPanel: General Panel Functionality for Load Display
// 
// Start: 19980531, UwS
// 
// 
// This is C++ 

#ifndef LPANEL_H
#define LPANEL_H


#include <iostream.h>
#include <fstream.h>
#include <qsize.h>
#include <qwidget.h>
#include <qarray.h>
#include <qcolor.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qtooltip.h>

typedef QArray<float> FArray;


class LPanel : public QWidget
{
    Q_OBJECT

private:
    static const int MIN_WIDTH;
    static const int MIN_HEIGHT;
    
    int xScale;     // One time step makes what x-step?
    float yScale;   // 100% of y() corresponds to: <scale>
    float yLines; // if <=0: do not draw scale lines, else: dynamic scaling and lines
    int redrawInterval;
    int myWidth, 
        myHeight;
    bool doShift;
    
    QString toolTip; // For Tool-Tips
    QString description; // For labeling in other Widgets
    QString name; // For referencing in other widgets
    
    QColor *graphColors; // Colours for each Graph
    QColor scaleColor; // Colour for scale Lines
    int numGraphs; // Number of Graphs
    bool incremental; // Are the Graphs to be stacked
    bool filled;      // fill area under graphs
    int numPoints; // actual number of x-range to display
    FArray *data; // Contains Graph Data
    
    void nextColumn();// Prepare for Insertion of next Column
    void lshift(int num = 1); // left shift data by <num> points
    
    QString doubleClickCmd;
    
    bool lowWMTriggerEnabled,
         highWMTriggerEnabled;
    QString lowBoundCmd,     // lower water mark
            highBoundCmd;    // higher water mark
    float lowWM,  // if this is fallen below and not null, lowBoundCmd is called
          highWM; // if this is exceeded and not null, highBoundCmd is called
    
    void callCmd(const QString s); // Call shell command
    
    void paintEvent( QPaintEvent * );
    void fullPaint(); // Paint the complete widget
    void diffPaint(); // Paint only the last column
    int rescale(); // get new y scaling
    void intervalCmds(); // Check interval violation and trigger Cmds
    
protected:   
    void setDescription(const char *d) {description = d;}
    void setName(const char *n) {name = n;}
    
    void setFilled(bool);
    void setIncremental(bool);
    bool isFilled() { return (filled); }
    bool isIncremental() { return incremental; }
    int nPoints(void) { return numPoints; }
    virtual void resizeEvent(QResizeEvent *);   
    void append(FArray &); // Insert new column of data
    
    int getXScale() const { return xScale;}
    void setXScale(int x) { xScale = x;}
   
    float getYScale() const { return yScale;}
    void setYScale(float y) { yScale = y;}
       
    float getYLines() const { return yLines;}
    void setYLines(float y) { yLines = y;}
    
    int getRedrawInterval() const { return redrawInterval;}
    void setRedrawIntervall(int r) {redrawInterval = r;}
    
    QColor& getGraphColor(int i) const {return graphColors[i];}
    void setGraphColor(int i, const QColor &c) {graphColors[i] = c;}
    
    const QColor& getScaleColor() const  {return scaleColor;}
    void setScaleColor(const QColor &c) {scaleColor = c;}
    
    int getNumGraphs() const {return numGraphs;}
    
    virtual void mouseDoubleClickEvent(QMouseEvent *);
    virtual void mousePressEvent(QMouseEvent *);
    
    // Make it a pure virtual class
    virtual void resample(void);          // Trigger resampling and append
    virtual bool getNewData(FArray *) = 0; // Gain new data
    
public:    
    //static const int QSECOND = 1000;
    
    LPanel(int n = 0,QWidget *parent=0, const char *name=0 );
    ~LPanel();

    void setSize(int width, int height);
    const char *getDescription() const {return description;}
    const char *getName() const {return name;}
    void setToolTip (const char *t);
    
    const char *getDoubleClickCmd() const { return doubleClickCmd;}
    void setDoubleClickCmd(const char *s) { doubleClickCmd = s;}

    float getLowWM() const        { return lowWM; }
    void setLowWM(float low)      { lowWM = low; }
    float getHighWM() const       { return highWM; }
    void setHighWM(float high)    { highWM = high; }
    
    const char *getLowBoundCmd() const  {return lowBoundCmd;}
    void setLowBoundCmd(const char *l)  { lowBoundCmd = l;}
    const char *getHighBoundCmd() const {return highBoundCmd;}
    void setHighBoundCmd(const char *h) { highBoundCmd = h;}    

public slots:
    virtual void wakeUp();
    
signals:
    void rightMouseButtonPressed(QPoint);
};


inline void LPanel::setFilled (bool yesno) 
{
    filled = yesno; 
    if (filled) 
        incremental = true;
}


inline void LPanel::setIncremental (bool yesno)
{
    incremental = yesno;
    if (!incremental) 
        filled = false;
}

    
#endif // LPANEL_H

