/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: Sensors.h,v 1.26 1999/01/12 20:08:06 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SENSORS_H
#define SENSORS_H

#define LM_NO_DATA -1000000
#define SENSOR_LABEL_LEN 10

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/sysctl.h>
#include <linux/sensors.h>
#include <linux/unistd.h>
#include <linux/sysctl.h>

#include "kapp.h"
#include "kconfig.h"
#include "qstring.h"

struct SensorValue
{
  double min;
  double max;
  double value;
};

class Sensor
{
private:
  int  sysctl_name[4];
  double graph_min;
  double graph_max;
  double sensorOffset;
  bool disabled;
  bool configurable;
  
protected:
  bool testAlarm( 
    int sysctl_addr2, 
    int sysctl_addr3, 
    long alarmMask );
  
  bool getVolt( SensorValue &sensor );
  bool getVidVolt( SensorValue &sensor );	
  bool getFan( SensorValue &sensor );
  bool getTemp( SensorValue &sensor );
  bool writeTemp( SensorValue &sensor );
  bool writeVolt( SensorValue &sensor );
  bool writeFan( SensorValue &sensor );
  
  bool saveSettings( 
    SensorValue &val, 
    const QString &name, 
    double scale );
  
  bool getSettings( 
    SensorValue &val, 
    QString &name, 
    double &scale );
  
  void Sensor::getScaleFactor( 
    int sysctl_addr3, 
    int &numScales, 
    int bufferLen, 
    long *scaleBuffer );
  
  bool setScaleFactor( 
    int sysctl_addr3, 
    int offset, 
    double factor );
  
  void setConfigurable( bool cfg );
  
  bool setOffset( double offset );
  
public:	
  
  Sensor( 
    int sysc1, 
    int sysc2, 
    int sysc3,
    int sysc4,		
    double grMin,
    double grMax );
  
  virtual ~Sensor();
  
  bool isDisabled();
  void setDisabled( bool d );
  int *getAddr();		
  virtual bool save();	
  virtual bool read( SensorValue &val );	
  virtual bool write( SensorValue &val );	
  virtual bool isTemp();	
  virtual bool isOsHystTemp();
  virtual void name( QString &name );
  virtual bool setName( QString &name );
  virtual bool isConfigurable();	
  virtual double scale();
  virtual bool setScale( double &scaleFactor );
  void graphRange( double &min, double &max );
  bool setGraphRange( double min, double max );
  virtual bool increaseGraphRange();
  virtual bool decreaseGraphRange();
  virtual bool increaseOffset();
  virtual bool decreaseOffset();
  double getOffset();
  virtual bool lowAlarmSettable();
  virtual bool highAlarmSettable();
  virtual bool scalable();
  virtual bool increaseScale();
  virtual bool decreaseScale();
  virtual bool nameSettable();	
  virtual bool displayDecimals();
  virtual bool displayUnits();
  virtual void units( QString &unitStr );	
  virtual bool isAlarm();
};

#endif
