/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: DockWidget.h,v 1.8 1999/02/03 21:45:03 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DOCKWIDGET_H
#define DOCKWIDGET_H

#include <qwidget.h>
#include <qpopupmenu.h>
#include <qlcdnumber.h>
#include <qtooltip.h>

class DynamicTip;

class DockWidget : public QLCDNumber
{
  Q_OBJECT
  
private:
  QPopupMenu *menu;
  int        toggleID;
  QColor     backGround;
  DynamicTip *dockTip;	
  
public:
  
  DockWidget(
    QWidget* parent = NULL,
    const char* name = NULL );
  
  ~DockWidget();
  
public slots:
  void display( int temp, bool alarm, QString &hint );	
  void dock();
  
  QRect tip( const QPoint &p );
  
private slots:
  void mousePressEvent(QMouseEvent *);
  
signals:
  void clicked();
  void exit_cmd();
  void showSettings();
  
protected slots:
  
protected:
  
  
};



#endif // DockWidget_included
