/***************************************************************************
                          kidentify.cpp  -  description
                             -------------------
    begin                : Fri Sep 3 1999
    copyright            : (C) 1999 by Rolf Jakob
    email                : rjakob@duffy1.franken.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
// #define __USE_GNU 1
extern "C" {
char * strsignal(int __sig);
}
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include <fcntl.h>
#include <ktopwidget.h>
#include <kapp.h>
#include <qwidget.h>
//#include <kkeyconf.h>
#include <qkeycode.h>
#include <qmlined.h>
#include <kmsgbox.h>
#include "kidentify.h"
#include "kidentify.moc"

kidentify :: kidentify(QWidget *, const char *name, const char *path)
	: KTopLevelWidget(name)
{
char buffer[1024],*p;
int i,nr,comma;
QString com,tmp,ltmp;
struct stat st;

	if (name) setCaption(name);

	filepath=path;
	corebt=0; ldconfigbt=0;
	nmbt=0;

	for (i=0;i<10;i++) {
		label[i]=0;
		value[i]=0;
		}

	needed_width=200;
	needed_height=300;

	frame=new QGroupBox(i18n("File Information"),this);
	stat(path,&st);

	nr=0;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Name :"));
	value[nr]=new QLabel(frame);
	value[nr]->setText(path);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Type :"));
	value[nr]=new QLabel(frame);
	value[nr]->setText(filetype(st.st_mode));

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Permission :"));
	value[nr]=new QLabel(frame);
	value[nr]->setText(fileperm(st.st_mode));

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Size :"));
	value[nr]=new QLabel(frame);
	sprintf(buffer,"%ld Bytes",st.st_size);
	value[nr]->setText(buffer);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Mutation Date :"));
	value[nr]=new QLabel(frame);
	strcpy(buffer,asctime(localtime(&st.st_mtime)));
	p=buffer+strlen(buffer)-1;
	while(*p=='\n' || *p=='\r') *p--=0;
	value[nr]->setText(buffer);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Change Date :"));
	value[nr]=new QLabel(frame);
	strcpy(buffer,asctime(localtime(&st.st_ctime)));
	p=buffer+strlen(buffer)-1;
	while(*p=='\n' || *p=='\r') *p--=0;
	value[nr]->setText(buffer);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Access Date :"));
	value[nr]=new QLabel(frame);
	strcpy(buffer,asctime(localtime(&st.st_atime)));
	p=buffer+strlen(buffer)-1;
	while(*p=='\n' || *p=='\r') *p--=0;
	value[nr]->setText(buffer);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("KDE File Magic:"));
	value[nr]=new QLabel(frame);
	tmp=magic(path,MAGIC_KDE);
	value[nr]->setText(tmp);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("System File Magic:"));
	value[nr]=new QLabel(frame);
	value[nr]->setText(magic(path,MAGIC_SYSTEM));

/*
	ltmp=libs(path);
	if (!ltmp.isEmpty()) {
		nr++;
		label[nr]=new QLabel(frame);
		label[nr]->setText(i18n("Dynamic Libraries:"));
		value[nr]=new QLabel(frame);
		value[nr]->setText(ltmp);
		ldconfigbt=new QPushButton(i18n("Rescan shared libraries"),this);
		connect(ldconfigbt,SIGNAL(clicked()),
			this,SLOT(run_ldconfig()));
		ldconfigbt->resize(ldconfigbt->sizeHint());
		ldconfigbt->show();
		}
*/
	slibval=nr;
	updatelibs(&nr);
	if (nr>slibval) {
		ldconfigbt=new QPushButton(i18n("Rescan shared libraries"),this);
		connect(ldconfigbt,SIGNAL(clicked()),
			this,SLOT(run_ldconfig()));
		ldconfigbt->resize(ldconfigbt->sizeHint());
		ldconfigbt->show();
		}

	comma=tmp.find(',');
	if (comma>0) tmp.truncate(comma);
	if (tmp=="application/x-coredump") {
		corebt=new QPushButton(i18n("Core information"),this);
		connect(corebt,SIGNAL(clicked()),
			this,SLOT(coreinfo()));
		corebt->resize(corebt->sizeHint());
		corebt->show();
		}
	
	if (tmp=="application/x-sharedlib") {
		nmbt=new QPushButton(i18n("Show Symbols"),this);
		connect(nmbt,SIGNAL(clicked()),
			this,SLOT(nminfo()));
		nmbt->resize(nmbt->sizeHint());
		nmbt->show();
		}

	for (i=0;i<10;i++) if (label[i]) {
		label[i]->resize(label[i]->sizeHint());
		value[i]->resize(value[i]->sizeHint());
		}

	frame->show();
	showit();
	resize(needed_width,needed_height);

//	setView(frame);
}

void kidentify::updatelibs(int *nr)
{
QString ltmp;

	ltmp=libs(filepath);
	if (!ltmp.isEmpty()) {
		(*nr)++;
		if (label[*nr]) delete label[*nr];
		if (value[*nr]) delete value[*nr];
		label[*nr]=new QLabel(frame);
		label[*nr]->setText(i18n("Dynamic Libraries:"));
		value[*nr]=new QLabel(frame);
		value[*nr]->setText(ltmp);
		label[*nr]->resize(label[*nr]->sizeHint());
		value[*nr]->resize(value[*nr]->sizeHint());
		}

}

QString kidentify :: magic(const char *path, int flag)
{
QString cmd;
char line[1024],*p;
FILE *fp;

	if (flag==MAGIC_KDE)
	cmd=QString("file -m ")+kapp->kde_mimedir()+"/magic "+QString(path);
	else
	cmd=QString("file ")+QString(path);

	fp=popen(cmd.data(),"r");
	if (!fp) return(QString(i18n("N/A")));
	fgets(line,sizeof(line),fp);
	if (feof(fp)) *line=0;
	pclose(fp);
	p=line+strlen(line)-1;
	while(*p=='\n') *p--=0;
	if (!strncmp(line,path,strlen(path))) p=line+strlen(path);
	while(*p==' ' || *p==':') p++;
	if (!*p) return(QString(i18n("N/A")));
	return(QString(p));
}

QString kidentify :: libs(const char *path)
{
QString cmd,libraries;
char line[1024],*p;
FILE *fp;

	cmd=QString("ldd ")+QString(path);

	fp=popen(cmd.data(),"r");
	if (!fp) return(QString(""));
	while(1) {
		fgets(line,sizeof(line),fp);
		if (feof(fp)) break;
		p=line; while(*p==' ' || *p=='\t') p++;
		libraries=libraries+QString(p);
		}
	pclose(fp);
	if (libraries.right(1)=="\n") {
		libraries=libraries.left(libraries.length()-1);
		}
	if (libraries.length()==0) libraries="";
	return(libraries);
}

QString kidentify :: filetype(mode_t mode)
{
	if (S_ISDIR(mode)) return(i18n("directory"));
	else if (S_ISLNK(mode)) return(i18n("symbolic link"));
	else if (S_ISREG(mode)) return(i18n("file"));
	else if (S_ISCHR(mode)) return(i18n("char device"));
	else if (S_ISBLK(mode)) return(i18n("block device"));
	else if (S_ISFIFO(mode)) return(i18n("fifo"));
	else if (S_ISSOCK(mode)) return(i18n("socket"));
	return(i18n("unknown"));
}

QString kidentify::fileperm(mode_t mode)
{
static QString c;

	c.sprintf(i18n("owner:%s%s%s, group:%s%s%s, other:%s%s%s%s%s%s (%3o)"),
	(mode&0400)?"r":"",(mode&0200)?"w":"",(mode&0100)?"x":"",
	(mode&040)?"r":"",(mode&020)?"w":"",(mode&010)?"x":"",
	(mode&04)?"r":"",(mode&02)?"w":"",(mode&01)?"x":"",
	(mode&01000)?i18n(",sticky"):"",
	(mode&02000)?i18n(",setgid"):"",
	(mode&04000)?i18n(",setuid"):"",
	mode&07777);
	return(c);
}

void kidentify::coreinfo()
{
char line[1024],*p;
FILE *fp;

	QMultiLineEdit *ml=new QMultiLineEdit(0);
	ml->setReadOnly(true);
	ml->setFont(kapp->fixedFont);
	QString cmd=QString("dcore ")+QString(filepath);

	fp=popen(cmd.data(),"r");
	if (!fp) {
		ml->insertLine(i18n("dcore execution error"));
		ml->insertLine(strerror(errno));
		return;
		}
	sprintf(line,i18n("Output of \"%s\" :"),cmd.data());
	ml->insertLine(line);
	while(1) {
		fgets(line,sizeof(line),fp);
		if (feof(fp)) break;
		p=line+strlen(line)-1;
		while(*p=='\r' || *p=='\n') *p--=0;
		ml->insertLine(line);
		}
	pclose(fp);
	ml->show();
}

void kidentify::nminfo()
{
char line[1024],*p;
FILE *fp;

	QMultiLineEdit *ml2=new QMultiLineEdit(0);
	ml2->setReadOnly(true);
	ml2->setFont(kapp->fixedFont);
	QString cmd=QString("nm -A ")+QString(filepath);

	fp=popen(cmd.data(),"r");
	if (!fp) {
		ml2->insertLine(i18n("nm execution error"));
		ml2->insertLine(strerror(errno));
		return;
		}
	sprintf(line,i18n("Output of \"%s\" :"),cmd.data());
	ml2->insertLine(line);
	while(1) {
		fgets(line,sizeof(line),fp);
		if (feof(fp)) break;
		p=line+strlen(line)-1;
		while(*p=='\r' || *p=='\n') *p--=0;
		ml2->insertLine(line);
		}
	pclose(fp);
	ml2->show();
}

void kidentify::run_ldconfig()
{
int rc,hrc,lrc;
QString cmd,msg;

	KConfig *config=kapp->getConfig();
	cmd=config->readEntry("ldconfig","/sbin/ldconfig");
	rc=system(cmd.data());

	if (rc) {
		msg.sprintf(i18n("Could not run %s"),
			cmd.data(),rc);
		hrc=rc>>8; lrc=rc&0xff;
		if (hrc) {
			msg.append("\n");
			if (hrc>128) msg.append(strsignal(hrc-128));
			else if (hrc==127) msg.append(i18n("Command not found"));
			else if (hrc==126) msg.append(i18n("Command not executable"));
			else	msg.append(strerror(hrc));
			}
		if (lrc) {
			msg.append("\n");
			if (lrc>128) msg.append(strsignal(lrc-128));
			else	msg.append(strerror(lrc));
			}

		KMsgBox::message(this,i18n("Execution Error"),
			msg,KMsgBox::STOP,i18n("Close"));
		} /* does not work :-( else {
		nr=slibval;
		updatelibs(&nr);
		showit();
		} */
}


kidentify :: ~kidentify()
{
//	KMsgBox :: message(this,"end","This is the end");

}

void kidentify::showit()
{
int i,maxw,maxtw,voffs,my,mx;

	maxw=0; maxtw=0; voffs=1;
	frame->resize(width(),height());
	for (i=0;i<10;i++) if (label[i]) {
		if (maxw<label[i]->width()) maxw=label[i]->width();
		}
	my=20;
	for (i=0;i<10;i++) if (label[i]) {
		label[i]->move(20,my);
		value[i]->move(40+maxw,my);
		if (maxtw<(value[i]->width()+40+maxw))
			maxtw=value[i]->width()+40+maxw;
		my+=value[i]->height()+voffs;
		}

	if (corebt || ldconfigbt || nmbt) my+=5;

	mx=20;

	if (ldconfigbt) {
		ldconfigbt->move(mx,my);
		mx+=ldconfigbt->width()+20;
		}
	if (corebt) {
		corebt->move(mx,my);
		mx+=corebt->width()+20;
		}
	if (nmbt) {
		nmbt->move(mx,my);
		}

	if (corebt) my+=corebt->height()+voffs;
	else if (ldconfigbt) my+=ldconfigbt->height()+voffs;

	needed_width=maxtw+20;
	needed_height=my+20;
}

void kidentify::resizeEvent(QResizeEvent *)
{
	showit();
}


int main(int argc, char* argv[])
{
char filename[1024];
int rc;

	filename[1023]=0;
	strncpy(filename,argv[0],1023);
	KApplication *app=new KApplication(argc,argv);
	if (argc>1) strncpy(filename,argv[1],1023);
	kidentify *w=new kidentify(0,filename,filename);

	app->setMainWidget(w);
	w->show();

	while(1)
		if ((rc=app->exec())!=1) break;
		
	return(rc);
}

