/*
 * khkglobalaccel.cpp
 *
 * Copyright (C) 1999 Lubos Lunak <l.lunak@email.cz>

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License as published by the Free Software Foundation; either
	version 2 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License
	along with this library; see the file COPYING.LIB.  If not, write to
	the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	Boston, MA 02111-1307, USA.
*/
 
#include "khkglobalaccel.h"

bool KHKGlobalAccel::x11EventFilter( const XEvent *event_ ) {

	if ( aKeyDict.isEmpty() ) return false;
	if ( event_->type != KeyPress ) return false;
	
	uint mod=event_->xkey.state & (ControlMask | ShiftMask | Mod1Mask);
	uint keysym= XKeycodeToKeysym(qt_xdisplay(), event_->xkey.keycode, 0);
	

	QDictIterator<KKeyEntry> *aKeyIt = new QDictIterator<KKeyEntry>( aKeyDict );
	aKeyIt->toFirst();
#define pE aKeyIt->current()
	while( pE ) { 
		int kc = pE->aCurrentKeyCode;
		if ( mod == keyToXMod( kc ) && keysym == keyToXSym( kc ) ) {
		break;
		}
		++*aKeyIt;
	}
	
	if ( !pE ) {
		return false;
	}
	
	if ( !pE ) {
		return false;
	}


	XAllowEvents(qt_xdisplay(), AsyncKeyboard, CurrentTime);
	XUngrabKeyboard(qt_xdisplay(), CurrentTime);
	XSync(qt_xdisplay(), false);
#if 0	
	connect( this, SIGNAL( activated() ), pE->receiver, pE->member);
	emit activated();
	disconnect( this, SIGNAL( activated() ), pE->receiver, pE->member );
#else
// this is actually the only important change, so this will probably
// change in KGlobalAccel and KHKGlobalAccel will be useless
	connect( this, SIGNAL( activated( const char*, const QString&, uint ) ), pE->receiver, pE->member);
	emit activated( aKeyIt->currentKey(), pE->descr, pE->aCurrentKeyCode );
	disconnect( this, SIGNAL( activated( const char*, const QString&, uint ) ), pE->receiver, pE->member );
#endif
	return true;
}

