#ifndef WIN_DIALOG_H 
#define WIN_DIALOG_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qpixmap.h>
#include <qlayout.h>
#include <qpushbt.h>
#include <kapp.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <qdialog.h>
#include <qlistview.h>

class win_dialog
    : public QDialog
    {
    Q_OBJECT
    public:
	win_dialog();
	void add_win( Window w );
	void act_win( Window w );
	QListViewItem* get_data();
	enum columns { w_title, w_command, w_class };
    protected slots:
	virtual void window_selected(QListViewItem*);
        virtual void select_pressed();
    protected:
	QDict< QListViewItem > window_titles;
	QString get_window_command( Window w );
	QString get_window_title( Window w );
	QString get_window_class( Window w );
	QListView* windows_list;
	Window last_autoact;
    };

// Inline

inline
QListViewItem* win_dialog::get_data()
    {
    return windows_list->currentItem();
    }


#endif
