/*****************************************************************************
 * This software is distributed under the terms of the General Public License.
 *
 * Program : kfstab
 * Authors : Dirk Holtwick & Andreas Reuter
 * E-Mail  : holtwick@uni-duisburg.de
 *           Andreas.Reuter@munich.netsurf.de
*****************************************************************************/

// KDE Header Files
#include <kapp.h>
#include <kprocess.h> // for getuid()
#include <kmsgbox.h>

// Application Header Files
#include "kfstab.h"

#define LOC i18n

// Global variables
    KApplication	*app;
    QString		ConfigWidth;
    QString		ConfigHeight;
    int			itisroot;

int main( int argc, char ** argv )
{
    KFstab	*toplevel;
    QString s;
   
    // Create a new KApplication object
    app = new KApplication ( argc, argv , "kfstab" );
    
    // Read current settings
    KConfig *conf = app->getConfig();
    conf->setGroup( "Window");
    ConfigWidth = conf->readEntry( "WinWidth", NULL );
    ConfigHeight = conf->readEntry( "WinHeight", NULL );

    // Only root can change something in this app
    if ( getuid() ) {
      s.sprintf( LOC( "Only root is allowed to modify %s.\n"
	       "Add, Delete and Save are therefore disabled." ), FSTAB );
      KMsgBox::message( 0, LOC( "Warning" ),
         s, KMsgBox::EXCLAMATION );
      itisroot = FALSE;
    }
    else itisroot = TRUE;

    // Create top level window
    toplevel = new KFstab();
    // Insert Main Widget
    app->setMainWidget( toplevel );
    toplevel->show();
    app->exec();
    
    // Save Settings
    conf->setGroup( "Window" );
    s.sprintf("%d", toplevel->width() );
    conf->writeEntry( "WinWidth", s );
    s.sprintf("%d", toplevel->height() );
    conf->writeEntry( "WinHeight", s );
    conf->sync();
}

