/***********************************************************************
**
**   resource.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  1999 by Heiner Lamprecht ( heiner@kijumfo.de )
**   begin        :  Sun Jun  6 1999
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef RESSOURCE_H
#define RESSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands

#define DEFAULT_V1                 "5400,0000N"
#define DEFAULT_V2                 "5000,0000N"

///////////////////////////////////////////////////////////////////
//
// Map checken, welche davon wirklich bentigt werden,
// auerdem "sinnvoll" sortieren ...

///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES
#define ID_PRIV_TOOLBAR             1

///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_HELP_CONTENTS            22222
#define ID_HELP_ABOUT               22223
#define ID_FILE_OPEN                10010
#define ID_FILE_MAPIMPORT           10011
#define ID_FILE_CLOSE               10012
#define ID_FILE_CLOSE_ALL           10013
#define ID_FILE_MAP                 10020
#define ID_FILE_CREATE              10030
#define ID_FILE_WAYPOINT            10035
#define ID_ZOOM_IN                  10050
#define ID_ZOOM_OUT                 10060
#define ID_FILE_PRINT               10080
#define ID_FILE_QUIT                10100
#define ID_LAYER_ADDSITES           10101
#define ID_LAYER_AIRPORT            10102
#define ID_LAYER_AIRSPACE           10103
#define ID_LAYER_CITY               10104
#define ID_LAYER_FLIGHT             10105
#define ID_LAYER_GLIDER             10106
#define ID_LAYER_HYDRO              10107
#define ID_LAYER_LAND               10108
#define ID_LAYER_NAV                10109
#define ID_LAYER_OUT                10110
#define ID_LAYER_RAIL               10111
#define ID_LAYER_ROAD               10112
#define ID_LAYER_TOPO               10113
#define ID_LAYER_WAYPOINT           10114
#define ID_REDRAW                   10120
#define ID_CONF_MAP                 10210
#define ID_CONF_KFLOG               10211
#define ID_FILE_SAVE                10221


#define ID_FILE_KONVERT             99999

///////////////////////////////////////////////////////////////////
// View-menu entries                    
#define ID_VIEW_TOOLBAR             12010
#define ID_VIEW_STATUSBAR           12020
#define ID_VIEW_OPTIONS             12030

///////////////////////////////////////////////////////////////////
// Help-menu entries
#define ID_HELP                     1002

#define ID_HELP_WHATS_THIS     			1004

///////////////////////////////////////////////////////////////////
// General application values
#define ID_STATUS_MSG               1001

#define IDS_DEFAULT                 "Ready."

#define IDS_APP_ABOUT               "KFLog\nVersion " VERSION

#define ID_STATUS_COORD_R           10011
#define ID_STATUS_COORD_H           10012
#define ID_STATUS_PROGRESS          10013
#define IDS_COORD_DEFAULT_R         "                  0"
#define IDS_COORD_DEFAULT_H         "                  0"

///////////////////////////////////////////////////////////////////
// MENU CONNECTS
#define CONNECT_CMD(submenu)           connect(submenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));connect(submenu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)))


///////////////////////////////////////////////////////////////////
// TOOLBAR CONNECT  
#define CONNECT_TOOLBAR(ToolBar)        connect(ToolBar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));connect(ToolBar, SIGNAL(highlighted(int,bool)), SLOT(statusCallback(int)))

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function)   case id:cmd_class_function ;break;

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them to change statusBar entry
#define ON_STATUS_MSG(id, message)     case id:  slotStatusHelpMsg(message);break;

#endif // RESOURCE_H

