/***********************************************************************
**
**   glidersite.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef GLIDERSITE_H
#define GLIDERSITE_H

#include <singlepoint.h>
#include <runway.h>

/**
  * This class provides handling the glider-sites. This class inherites
  * "SinglePoint".
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */

class GliderSite : public SinglePoint
{
 public:
  /**
    * Creates a new GliderSite-object. n is the name of the site,
	  * latPos and lonPos give the position, elev is the elevation and f the
	  * frequency, winch indicates the type of launching available.
    */
  GliderSite(QString n, long latPos, long lonPos, unsigned int elev,
              QString f, bool winch = false,
              struct runway* rwDat = 0, unsigned int rwN = 0);
  /** */
  ~GliderSite();
  /**
    * Draws the glidersite into the given painter.
    */
  virtual void drawMapElement(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /**
    * Virtual function for writing the element-data into the given
    * binary-map-file.
    */
  virtual bool writeElementBin(const char* fileName);
  /**
    * Virtual function for writing the element-data into the given
    * ascii-map-file.
    */
  virtual bool writeElementAscii(const char* fileName);

 private:
  /** The elevation */
  unsigned int elevation;
  /** The frequency */
  QString frequency;
  /**
    * The launching-type. "true" if the site only has a winch, "false",
    * if aero tow is also available.
    */
  bool winch;
  /** Contains the runway-data. */
  struct runway* rwData;
  /** Contains the number of runways. */
  unsigned int rwNum;
};

#endif
