/***********************************************************************
**
**   flight.cpp
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  1999 by Heiner Lamprecht ( heiner@kijumfo.de )
**   begin        :  Tue Sep 28 1999
**
**                :  3/10/99 Some fixes by Jan Max Walter Krueger
**                :  ( jkrueger@physics.otago.ac.nz )
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#include <stdlib.h>

#include <flight.h>
#include <igc.h>
#include <mapcalc.h>
#include <wp.h>

#include <kapp.h>
#include <kiconloader.h>
#include <qlist.h>
#include <qpointarray.h>
#include <qregion.h>
#include <qtextstream.h>

void Flight::drawMapElement(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon)
{
  extern double _scale[];
  extern double _currentScale;
  struct flightPoint pointA, pointB;

  double drawXA, drawYA, drawXB, drawYB, latitude, longitude,
         projX, projY;
  long temp;

  for(unsigned int n = 2; n < routeLength; n++) {
    pointA = flightRoute[n - 1];
    pointB = flightRoute[n];

    temp = pointA.longitude - mapCenterLon;
    latitude = numToRad(pointA.latitude);
    longitude = numToRad(temp);

    projX = calc_X_Lambert(latitude,longitude);
    projY = calc_Y_Lambert(latitude,longitude);

    drawXA = projX * RADIUS / _currentScale + dX;
    drawYA = projY * RADIUS / _currentScale + dY;

    temp = pointB.longitude - mapCenterLon;
    latitude = numToRad(pointB.latitude);
    longitude = numToRad(temp);

    projX = calc_X_Lambert(latitude,longitude);
    projY = calc_Y_Lambert(latitude,longitude);

    drawXB = projX * RADIUS / _currentScale + dX;
    drawYB = projY * RADIUS / _currentScale + dY;

    // Strecke einzeichnen
    if(pointA.nearWP) {
      targetPainter->setPen(QPen(QColor(255,0,255), 3));
    } else if(pointB.vario < -1) {
      targetPainter->setPen(QPen(QColor(255,0,0), 3));
    } else if(pointB.vario > 1){
      targetPainter->setPen(QPen(QColor(0,0,255), 3));
    } else {
      targetPainter->setPen(QPen(QColor(0,255,0), 3));
    }
    targetPainter->drawLine(drawXA, drawYA, drawXB, drawYB);

    // Was bezweckt diese Abfrage???
    if(_currentScale > _scale[3]) {
      drawXB -= 4;
      drawYB -= 4;

      targetPainter->setBrush(NoBrush);
      targetPainter->setPen(QPen(QColor(255,0,255), 1));
      targetPainter->drawEllipse(drawXB, drawYB, 8, 8);
    }
  }

  if(!wpList.count()) return;

  struct wayPoint* curWP;

  curWP = wpList.at(0);

  temp = curWP->longitude - mapCenterLon;
  latitude = numToRad(curWP->latitude);
  longitude = numToRad(temp);

  projX = calc_X_Lambert(latitude,longitude);
  projY = calc_Y_Lambert(latitude,longitude);

  drawXA = projX * RADIUS / _currentScale + dX;
  drawYA = projY * RADIUS / _currentScale + dY;

  targetPainter->setBrush(NoBrush);
  targetPainter->setPen(QPen(QColor(0,0,200), 2));
  targetPainter->drawEllipse((drawXA - 7), (drawYA - 7), 14, 14);

QString text;
text.sprintf("Mastab: %d, ", _currentScale);
warning(text);

text.sprintf("Lngengrad: %d", curWP->longitude);
warning(text);

text.sprintf("Position Startpunkt: %d / %d",
  curWP->latitude, curWP->longitude - mapCenterLon);
warning(text);

text.sprintf("Projektion Startpunkt: %f / %f",
  drawXA, drawYA);
warning(text);

  char* kflog_dir = "/kflog/map";
  if(_currentScale > _scale[3]) {
    kflog_dir = "/kflog/map/small";
  }
  for(unsigned int loop = 1; loop < (wpList.count() - 1); loop++) {
    curWP = wpList.at(loop);

    temp = curWP->longitude - mapCenterLon;
    latitude = numToRad(curWP->latitude);
    longitude = numToRad(temp);

text.sprintf("Lngengrad: %d", curWP->longitude);
warning(text);

text.sprintf("Position %d. Wegpunkt: %d / %d",
  loop, curWP->latitude, curWP->longitude - mapCenterLon);
warning(text);
    projX = calc_X_Lambert(latitude,longitude);
    projY = calc_Y_Lambert(latitude,longitude);

    drawXB = projX * RADIUS / _currentScale + dX;
    drawYB = projY * RADIUS / _currentScale + dY;

text.sprintf("Projektion %d. Wegpunkt: %f / %f",
  loop, drawXB, drawYB);
warning(text);

    targetPainter->setBrush(NoBrush);
    targetPainter->setPen(QPen(QColor(0,0,200), 2));
    targetPainter->drawEllipse((drawXB - 7), (drawYB - 7), 14, 14);
    targetPainter->drawPixmap(drawXB - 10, drawYB - 32,
       Icon(KApplication::kde_datadir() + kflog_dir + "/routepoint.xpm"));

    targetPainter->setPen(QPen(QColor(0,0,0), 2));
    targetPainter->drawLine(drawXB, drawYB, drawXA, drawYA);

    drawXA = drawXB;
    drawYA = drawYB;
  }

  curWP = wpList.at(wpList.count() - 1);

  temp = curWP->longitude - mapCenterLon;
  latitude = numToRad(curWP->latitude);
  longitude = numToRad(temp);

  projX = calc_X_Lambert(latitude,longitude);
  projY = calc_Y_Lambert(latitude,longitude);

  drawXB = projX * RADIUS / _currentScale + dX;
  drawYB = projY * RADIUS / _currentScale + dY;

text.sprintf("Lngengrad: %d", curWP->longitude);
warning(text);

text.sprintf("Position Landepunkt: %d / %d",
  curWP->latitude, curWP->longitude - mapCenterLon);
warning(text);

text.sprintf("Projektion Landepunkt: %f / %f",
  drawXB, drawYB);
warning(text);

  targetPainter->setBrush(NoBrush);
  targetPainter->setPen(QPen(QColor(0,0,200), 2));
  targetPainter->drawEllipse((drawXB - 7), (drawYB - 7), 14, 14);

  targetPainter->setPen(QPen(QColor(0,0,0), 2));
  targetPainter->drawLine(drawXB, drawYB, drawXA, drawYA);
}

QString Flight::getID()
{
  return gliderID;
}

QString Flight::getLandSite()
{
  return landSite;
}

QString Flight::getLandTime()
{
  return landTime;
}

QString Flight::getPilot()
{
  return pilotName;
}

QString Flight::getStartSite()
{
  return startSite;
}

QString Flight::getStartTime()
{
  return startTime;
}

QString Flight::getType()
{
  return gliderType;
}

QString Flight::getDate()
{
  return date;
}

void Flight::setFlightHeader(QString pilot, QString gType,
	        QString gID, QString d)
{
  pilotName = pilot;
  gliderType = gType;
  gliderID = gID;
  date = d;
}

void Flight::setRoute(struct flightPoint* fRoute,
          unsigned int rLength)
{
  routeLength = rLength;
  flightRoute = fRoute;

  checkWaypoints();
}

void Flight::appendWaypoint(QString name, long latitude, long longitude)
{
  struct wayPoint* newPoint = new wayPoint;
  newPoint->name = name;
  newPoint->latitude = latitude;
  newPoint->longitude = longitude;
  newPoint->time = 0;
  newPoint->reached = false;

  wpList.append(newPoint);
}

void Flight::checkWaypoints()
{
  flightPoint* current;
  double wpDist;

  for(unsigned int loop = 0; loop < routeLength; loop++) {
    current = &flightRoute[loop];

    wayPoint* curWP;
    for(unsigned int loopB = 0; loopB < wpList.count(); loopB++) {
      curWP = wpList.at(loopB);

      wpDist = dist(curWP->latitude, curWP->longitude,
                        current->latitude, current->longitude);
      // Zur Zeit Grenze bei 500 Metern
      if(wpDist <= 0.5) {
        current->nearWP = true;
        if(!curWP->reached) {
          // Entfernungen "richtig" einstellen!!!
          // "Nchsten" Flugpunkt ermitteln!!!
          curWP->reached = true;
          curWP->time = current->time;
        }
      }
    }
  }
}

QList<struct wayPoint>* Flight::getWPList()
{
  return &wpList;
}

Flight::Flight(MapContents* mContents, QFile* flightDataFile)
    : LineElement("flight", BaseMapElement::Flight)
{
  mapContents = mContents;

  wpList.setAutoDelete(true);
  pilotName = 0;
  gliderType = 0;
  gliderID = 0;

////////////////////////////////////////////////////////////////////////////
//
// Spter sollte hier zumindest eine Kontrolle der Endung erfolgen ...
  loadIGC(flightDataFile, this);
//
////////////////////////////////////////////////////////////////////////////
}

Flight::~Flight()
{
  wpList.~QList();
}
