/***********************************************************************
**
**   airspace.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef AIRSPACE_H
#define AIRSPACE_H

#include <areaelement.h>

/**
  * This class is used for the several airspaces. The object can be
  * one of: AirC, AirCtemp, AirD, AirDtemp, ControlD, AirElow, AirEhigh, AirF,
  * Restricted, Danger, LowFlight
  *
  * @see BaseMapElement#objectType
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */
class Airspace : public AreaElement
{
 public:
  /**
    * Creates a new Airspace-object. n is the name, t the typeID. length
    * is the number of coordinates. upper and upperType give the upper limit
    * of the airspace and the type of value (MSL, GND, FL); lower and
    * lowerType give the value for the lower limit.
    */
  Airspace(QString n, unsigned int t, unsigned int length,
            long* latList, long* lonList,
            unsigned int upper = 0, unsigned int upperType = 0,
            unsigned int lower = 0, unsigned int lowerType = 0);
  /** */
  ~Airspace();
  /**
    * Draws the element into the given painter.
    */
//  virtual void drawMapElement(QPainter* targetPainter,
//        double dX, double dY, long mapCenterLon);

  /** */
  QRegion* drawRegion(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /**
    * Virtual function for writing the element-data into the given
    * binary-map-file.
    */
  virtual bool writeElementBin(const char* fileName);
  /**
    * Virtual function for writing the element-data into the given
    * ascii-map-file.
    */
  virtual bool writeElementAscii(const char* fileName);
  /**
    * The three types of elevation-data used in the maps.
    */
  enum LimitType {NotSet, MSL, GND, FL};

 private:
  /** */
  unsigned int lLimit;
  /** */
  unsigned int lLimitType;
  /** */
  unsigned int uLimit;
  /** */
  unsigned int uLimitType;
};

#endif
