/***************************************************************************
                          tablet.h  -  description
                             -------------------
    begin                : Fri Jul 9 1999
    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABLET_H
#define TABLET_H

#include <mapobject.h>

#include <krestrictedline.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qwidget.h>

#include <X11/Xlib.h>
#include <X11/extensions/XInput.h>
#include <X11/Xutil.h>

#define INVALID_EVENT_TYPE -1

/**
  * This class provides basic functions for accessing a tablet.
  * The class is based on the "xinput" by Frederic Lepied.
  * @author Heiner Lamprecht
  * @version 0.0
  */

class Tablet : public QWidget
{
//  Q_OBJECT

 public:
  Tablet(QWidget* parent);
  ~Tablet();
  bool isPresent();
  void getPoints(bool onlyOne, QList<Location> *pointList, char* name);

 private:
  int motionType;
  int buttonPressType;
  int buttonReleaseType;
  int keyPressType;
  int keyReleaseType;
  int proximityInType;
  int proximityOutType;
  Display* display;
  QWidget* parent;

  int registerEvents(XDeviceInfo* info, bool handleProximity);

  void readEvents(bool onlyOne, QList<Location> *pointList);

  XDeviceInfo* findInfo(char* name, bool only_ext);
};

class TabletDialog : public QWidget
{
  Q_OBJECT

 public:
  TabletDialog(QWidget* parent, bool onlyone);
  ~TabletDialog();
  void getPointList(long* latitude, long* longitude);
  int getListLength();

 public slots:
  void startDigitizing();
  void stopDigitizing();
  void calibrateTablet();

 private:
  bool done;
  bool onlyOne;
  double scale;
  double angle;
  char* tabName;
  double v1;
  double v2;
  QDialog* dW;
  QGridLayout* dWLayout;
  QPushButton* cal;
  QLabel* dWL1;
  QLabel* calL;
  QLabel* point1L;
  KRestrictedLine* point1E1;
  KRestrictedLine* point1E2;
  QPushButton* point1B;
  QLabel* point2L;
  KRestrictedLine* point2E1;
  KRestrictedLine* point2E2;
  QPushButton* point2B;
  QLabel* point3L;
  KRestrictedLine* point3E1;
  KRestrictedLine* point3E2;
  QPushButton* point3B;
  Tablet* tab;
  /** 1. digitized point */
  Location* point1D;
  /** vectorMapX and vectorMapY are used to calibrate the tablet. */
  double vectorMapX;
  double vectorMapY;
  Location* point2D;
  Location* point3D;
  /**
    * The coordinates for the object, given as an array in the
    * internal format. The size of the array is given during
    * construction of the object.
    *
    * This one is for the latitude.
    */
  long* latList;
  /** And this for the longitude. */
  long* lonList;
  int listLength;

  QList<Location> pointList;

 private slots:
  void inputPoint1();
  void inputPoint2();
  void inputPoint3();
};

#endif

