/*************************************************************************
 *                                                                       *
 *  KDisk Utils - KSlot V0.9.5                                           *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * Idea for this part I pinched from a small program from which I dont  *
 * know where it came from and whos the author.                         *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#include <stdlib.h>
#include <linux/cdrom.h>

int changeSlot(int x_slot,const char *device){
	int fd;           /* file descriptor for CD-ROM device */
	int status;       /* return status for system calls */

	fd = open (device, 0);
	if (fd<0) {
		return 1;
	}

	status = ioctl (fd, CDROM_SELECT_DISC, x_slot);
	if (status != 0) {
		close (fd);		
		return 2;
	}

	status = close (fd);
	if (status != 0) {
		return 3;
	}

	return 0;
}
