/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.5                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#include "summary.h"

Summary::~Summary(){
}

Summary::Summary(QWidget *parent=0):QWidget (parent){
	liste=new KTabListBox (this,"Disk-Summary",5,2);
	liste->clearTableFlags(Tbl_hScrollBar);
	liste->setTableFlags(Tbl_autoHScrollBar);
	liste->setTableFlags(Tbl_autoVScrollBar);
	liste->setSeparator('\n');
	liste->setColumn(0, klocale->translate("Mountpoint"), 2);
	liste->setColumn(1, klocale->translate("Device"),2);
	liste->setColumn(2, klocale->translate("Capacity"),  2);
	liste->setColumn(3, klocale->translate("Free"),  2);
	liste->setColumn(4, klocale->translate("Free(%)"),  1);

	connect(liste,SIGNAL(selected(int,int)),SLOT(slot_listeSelected(int,int)));
	setMinimumSize(300,250);
}

void Summary::resizeEvent(QResizeEvent *){
	liste->setGeometry(20,20,width()-40,height()-40);

	liste->setColumnWidth(0,liste->width()/5);
	liste->setColumnWidth(1,liste->width()/5);
	liste->setColumnWidth(2,liste->width()/5);
	liste->setColumnWidth(3,liste->width()/5);
	liste->setColumnWidth(4,liste->width()/5);
	
	liste->repaint();

}

QString fitSize(float s, bool c){
	char einheit[6]="Bytes";
	char result[300]="";

	if (c){
		if (s>1000){
			s=s/1024;
			einheit="Kb   ";
		}
		if (s>1000){
			s=s/1024;
			einheit="Mb   ";
		}
		if (s>1000){
			s=s/1024;
			einheit="Gb   ";
		}
		sprintf(result,"%.2f %s",s,einheit);	
	}else{
		sprintf(result,"%.2f",s);	
	}

	QString tmp=result;
	if (tmp.right(3)==".00") tmp=tmp.left(tmp.length()-3);
	return tmp;
}

void Summary::addDrive(diskData *dd){
	QString st;

	if (dd->ismounted){
		int p=(int)(((dd->disk_capacity-dd->disk_used)/dd->disk_capacity)*100);
		st.sprintf("%s\n%s\n%s\n%s\n%i%%",dd->mountpoint.data(),
						dd->devicename.data(),
						fitSize(dd->disk_capacity,true).data(),
						fitSize(dd->disk_capacity-dd->disk_used,true).data(),
						p);
	}else{
		st.sprintf(klocale->translate("%s\n is\nunmounted\n\n"),dd->mountpoint.data());
	}
	liste->insertItem(st);
}

void Summary::slot_listeSelected(int index,int column){
	emit selected(index);
}
