/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.5                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#ifndef KDFREE_DOCK_H
#define KDFREE_DOCK_H

#include "diskdata.h"
#include "kdconfig.h"

#include <qpopupmenu.h>
#include <qwidget.h>

class KDFreeDock:public QWidget{
	Q_OBJECT
public:
	KDFreeDock(QWidget *parent=0, const char *name=0, KDConfig *config=0);
	~KDFreeDock();

private:
	KDConfig	*config;
	QTimer		*timer;
	QPopupMenu	*menu;
	diskData	*dd[3];
	
	void 		paintEvent(QPaintEvent *);
	void		mouseReleaseEvent(QMouseEvent *e);

private slots:
	void 		slot_close();
	void		slot_updateWidget();
	void		slot_menu_about();
	void		slot_menu_config();
	void		slot_menu_start_kdfree();
};

#endif KDFREE_H

