/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.5                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#include "diskdata.h"

#include <stdio.h>
#include <sys/vfs.h>

#include <kapp.h>
#include <kmsgbox.h>

diskData::~diskData(){
}

diskData::diskData(QString mp,KDConfig *cfg){
	mountpoint=mp;
	config=cfg;
	getValues();
}

void diskData::update(){
	getValues();
}

void diskData::getValues(){
	struct statfs sysstat;
	char s[200];
	double f_blocks;
	double f_bsize;
	double f_bavail;
	FILE *mountfile;
	char mf_device[1000];
	char mf_mountpoint[1000];
	char mf_filesystem[1000];
	char mf_readwrite[1000];
	int a,b;

	mountfile=fopen("/proc/mounts","r");
	setvbuf(mountfile,NULL,_IONBF,0);
	rewind(mountfile);

	filesystem=klocale->translate("unknown");
	readwrite=klocale->translate("unknown");
	devicename=klocale->translate("unknown");
	ismounted=false;


	while(fscanf(mountfile, "%s %s %s %s %d %d", mf_device, mf_mountpoint, mf_filesystem, mf_readwrite, &a, &b)!=EOF){
		if (QString(mf_mountpoint)==mountpoint){
			filesystem=mf_filesystem;
			readwrite=mf_readwrite;
			devicename=mf_device;
			ismounted=true;
		}
	}	

	if (ismounted){
		statfs(mountpoint,&sysstat);
  
		f_blocks=sysstat.f_blocks;
		f_bsize=sysstat.f_bsize;
		f_bavail=sysstat.f_bavail;

		disk_capacity=f_blocks*f_bsize;
		disk_used=(f_blocks-f_bavail)*f_bsize;

		sprintf(s, "%i",sysstat.f_blocks);disk_blocks=s;
		sprintf(s, "%i",sysstat.f_bsize);disk_bl_size=s;

		icon=config->icon_unknown;
		if (filesystem=="minix") icon=config->icon_minix;
		if (filesystem=="ext2") icon=config->icon_ext2;
		if (filesystem=="vfat") {
			if (devicename.right(devicename.findRev('/')).find("/fd")==0)		
				icon=config->icon_vfat_fd;
			else
				icon=config->icon_vfat_hd;
		}
		if (filesystem=="nfs") icon=config->icon_nfs;
		if (filesystem=="smbfs") icon=config->icon_smbfs;
		if (filesystem=="iso9660") icon=config->icon_iso9660;
		if (filesystem=="msdos") icon=config->icon_msdos;
		if (filesystem=="hfs") icon=config->icon_hfs;
		
		if ((icon==config->icon_unknown)&&(config->unknown_fs==false)) {
			KMsgBox	*notice;
	
			notice=new KMsgBox();
			if (notice->yesNo(0,klocale->translate("Attention"),
				klocale->translate(	"You've got a filesystem that KDFree doesnt know!\n"
							"Please have a look at the file Unknown_FS.txt\n"
							"which came with this package!\n\n"
							"Pressing Ok wont show this warning again..."),
				KMsgBox::INFORMATION,klocale->translate("Ok"),klocale->translate("Cancel"))==1){
					config->unknown_fs=true;
			}
			delete(notice);
		}
	}else{
		icon=config->icon_unmounted;
	}
}	
