#include <unistd.h>
#include <sys/stat.h>
#include <time.h>
#include <fcntl.h>
#include <ktopwidget.h>
#include <kapp.h>
#include <qclipboard.h>
#include <kmsgbox.h>
#include <kiconloader.h>
#include <kkeydialog.h>
#include "kdsing.h"
#include "kdsing.moc"

#define POP_LCOPY	1
#define POP_RCOPY	2

#define M_EXIT		21
#define M_PREF		22
#define M_CKEYS		23

#define TB_LINE		10
#define TB_STOP		11
#define TB_EXIT		12
#define TB_HELP		13
#define TB_DOIT		14
#define TB_CLEAR	15
#define TB_SAY		16


void klistbox :: mousePressEvent(QMouseEvent *m)
{
	if (m->button()==RightButton) {
		current_line=findItem(m->y());
		if (current_line>=0)
			emit popup(current_line,m->x(),m->y());
		}
	else QListBox::mousePressEvent(m);
}
	
kdsing :: kdsing(QWidget *, const char *name)
	: KTopLevelWidget(name)
{
	pi=0;
	kacc=new KAccel(this);
	kacc->insertItem(i18n("Preferences"),"Preferences",CTRL + Key_R);
	kacc->connectItem("Preferences",this,SLOT(showPreferences()));
	kacc->insertItem(i18n("Clear Window"),"ClearWindow",CTRL + Key_L);
	kacc->connectItem("ClearWindow",this,SLOT(clearWindow()));
	kacc->insertItem(i18n("Search"),"Search",CTRL + Key_K);
	kacc->connectItem("Search",this,SLOT(doit()));
	kacc->insertItem(i18n("Pronounce Word"),"PronounceWord",CTRL + Key_A);
	kacc->connectItem("PronounceWord",this,SLOT(startsay()));
	kacc->connectItem(KAccel::Quit,this,SLOT(exit()));
	kacc->readSettings();
	
	settingwindow=0;
	menubar=new KMenuBar(this);
	filemenu=new QPopupMenu;
	optionmenu=new QPopupMenu;
	menubar->insertItem(i18n("&File"),filemenu);
	menubar->insertItem(i18n("&Options"),optionmenu);
	filemenu->insertItem(i18n("&Quit"),M_EXIT);
	optionmenu->insertItem(i18n("&Preferences"),M_PREF);
	kacc->changeMenuAccel(filemenu,M_EXIT,KAccel::Quit);
//	filemenu->setAccel(CTRL + Key_W,M_EXIT);
//	optionmenu->setAccel(CTRL + Key_R,M_PREF);
	kacc->changeMenuAccel(optionmenu,M_PREF,"Preferences");
	optionmenu->insertItem(i18n("Configure Keys"),M_CKEYS);
	QString at = "kdsing 0.2.1";
	at += i18n("\n\nRolf Jakob (rjakob@duffy1.franken.de)\n\ndsing frontend for the KDE Desktop Environment");
	helpMenu = kapp->getHelpMenu(true, at.data());
	menubar->insertItem(i18n("&Help"),helpMenu);
	setMenu(menubar);
	menubar->show();

	KIconLoader *loader=kapp->getIconLoader();

	toolbar=new KToolBar(this);
	toolbar->insertButton(loader->loadIcon("reload.xpm"),
		TB_DOIT,true,i18n("Search"));
	toolbar->insertButton(loader->loadIcon("filedel.xpm"),
		TB_CLEAR,true,i18n("Clear Window"));
	toolbar->insertButton(loader->loadIcon("exclamation.xpm"),
		TB_SAY,true,i18n("Pronounce Word"));
	toolbar->insertButton(loader->loadIcon("help.xpm"),
		TB_HELP,true,i18n("Help"));
	toolbar->insertButton(loader->loadIcon("exit.xpm"),
		TB_EXIT,true,i18n("Exit"));
	toolbar->insertButton(loader->loadIcon("stop.xpm"),
		TB_STOP,true,i18n("Stop Searching"));
	toolbar->setItemAutoSized(TB_LINE,true);
	toolbar->setFullWidth(true);
	toolbar->setBarPos(KToolBar::Top);
	toolbar->setItemEnabled(TB_STOP,false);
	toolbar->setItemEnabled(TB_SAY,false);

	lined=new KToolBar(this);
	lined->insertLined("",TB_LINE,SIGNAL(returnPressed()),
		this,SLOT(doit()));
	lined->setItemAutoSized(TB_LINE,true);
	lined->setFullWidth(true);
	lined->setBarPos(KToolBar::Top);
	addToolBar(toolbar);
	addToolBar(lined);
	enableToolBar();
	toolbar->show();
	lined->show();
	connect(toolbar,SIGNAL(clicked(int)),this,SLOT(menucallback(int)));

	statusbar=new KStatusBar(this);
	statusbar->insertItem(QString("0000000 ")+i18n("lines"),1);
	statusbar->insertItem("",2);
	setStatusBar(statusbar);
	statusbar->changeItem("",1);
	statusbar->show();

	box=new klistbox(this);
	connect(box,SIGNAL(popup(int,int,int)),this,SLOT(showpopup(int,int,int)));

	popmenu=new QPopupMenu();
	popmenu->insertItem(i18n("Copy left word"),POP_LCOPY);
	popmenu->insertItem(i18n("Copy right word"),POP_RCOPY);
	connect(popmenu,SIGNAL(activated(int)),
		this,SLOT(popcallback(int)));

	connect(menubar,SIGNAL(activated(int)),this,SLOT(menucallback(int)));

	setView(box);
}


kdsing :: ~kdsing()
{
//	KMsgBox :: message(this,"end","This is the end");

}

void kdsing::exit()
{
	if (loading && pi) pclose(pi);
	kapp->quit();
}

void kdsing::closeEvent(QCloseEvent *)
{
	exit();
}

void kdsing::showPreferences()
{
if (settingwindow) {
	settingwindow->raise();
	return;
	}
settingwindow=new settings;
settingwindow->show();
settingwindow->readconfig();
connect(settingwindow,SIGNAL(dialogClosed(bool)),
	this,SLOT(windowclosed(bool)));
}

void kdsing::clearWindow()
{
box->clear();
}

void kdsing::menucallback(int no)
{
	KConfig *config=kapp->getConfig();
	config->setGroup("kdsing");

	switch(no) {
		case M_EXIT:
		case TB_EXIT:
			exit();
			break;
		case M_CKEYS:
			KKeyDialog::configureKeys(kacc);
			kacc->changeMenuAccel(optionmenu,M_PREF,"Preferences");
			break;
		case M_PREF:
			showPreferences();
			break;
		case TB_HELP:
			kapp->invokeHTMLHelp(0,0);
			break;
		case TB_STOP:
			loading=false;
			break;
		case TB_DOIT:
			doit();
			break;
		case TB_CLEAR:
			clearWindow();
			break;
		}
}

void kdsing::windowclosed(bool)
{
	if (!settingwindow) return;
	disconnect(settingwindow,SIGNAL(dialogClosed(bool)),
	this,SLOT(windowclosed(bool)));
	delete settingwindow;
	settingwindow=0;
}


#define ERRFILE	"/tmp/kdsing.err"

void kdsing::doit()
{
char bline[1024],sline[1024],*p;
int found,rc,fd;
struct stat st;
QString cmd,searchstring;
int stopat;

	found=0; stopat=-1;

	KConfig *config=kapp->getConfig();
	config->setGroup("kdsing");

	if (config->readBoolEntry("zgrep",false))
		cmd="zgrep ";
	else	cmd="grep ";

	if (config->readBoolEntry("ignorecase",false))
		cmd+="-i ";

	if (config->readBoolEntry("regexp",false))
		cmd+="-E ";

	if (config->readBoolEntry("wordsearch",false))
		cmd+="-w ";

	searchstring=lined->getLinedText(TB_LINE);
	searchstring.detach();

	if (config->readBoolEntry("atbeginning",false))
		searchstring.prepend("^");

	cmd+="\""+searchstring+"\" ";

	cmd+=config->readEntry("words",DEFWORDS);

	if (config->readBoolEntry("showcommand",false))
		statusbar->changeItem(cmd,2);

	if (config->readBoolEntry("clearlist",true))
		box->clear();

	if (!config->readBoolEntry("showall",true))
		stopat=config->readNumEntry("maxhits",DEFHITS);

	::close(2);
	::open(ERRFILE,O_WRONLY|O_CREAT|O_TRUNC,0666);
	pi=popen(cmd.data(),"r");
	if (pi) {
		toolbar->setItemEnabled(TB_STOP,true);
		loading=true;
		while(loading) {
			fgets(bline,sizeof(bline),pi);
			if (feof(pi)) break;
			box->insertItem(bline);
			found++;
			if (!(found%10)) {
				sprintf(sline,i18n("%d line(s)"),found);
				statusbar->changeItem(sline,1);
				}
			kapp->processEvents();
			if (stopat>0 && found>=stopat) break;
			}
		pclose(pi);
		pi=0;
		}
	::close(2);
	sprintf(sline,i18n("%d line(s)"),found);
	toolbar->setItemEnabled(TB_STOP,false);
	statusbar->changeItem(sline,1);
	rc=stat(ERRFILE,&st);
	if (!rc && st.st_size) {
		fd=open(ERRFILE,O_RDONLY);
		char *buf=new char[st.st_size+1];
		rc=read(fd,buf,st.st_size);
		buf[rc]=0;
		if (buf[rc-1]=='\n') buf[rc-1]=0;
		p=strrchr(buf,'\n');
		if (!p) p=buf; else p++;
		sprintf(bline,"--> %s <--",p);
		statusbar->changeItem(bline,2);
		delete buf;
		}
	::open("/dev/console",O_WRONLY);
	::unlink(ERRFILE);
	if (!found) box->insertItem(i18n("*** nothing found ***"));
}

void kdsing::startsay(int n)
{
char path[1024],cmd[1024];
int rc;

if (n<0) n=box->current_line;
	
strcpy(path,box->text(n));
sprintf(cmd,"say %s",path);
rc=system(cmd);
}

void kdsing::showpopup(int,int ex, int ey)
{
	popmenu->popup(QCursor::pos());
}

void kdsing::popcallback(int id)
{
QClipboard *cb=kapp->clipboard();
QString tmp;
int c;

	switch (id) {
/*	case POP_SAY:
		startsay(box->current_line);
		break;
*/
	case POP_LCOPY:
		tmp=QString(box->line());
		if ((c=tmp.find("::"))>0) tmp.truncate(c);
		tmp.stripWhiteSpace();
		cb->setText(tmp.data());
		break;
	
	case POP_RCOPY:
		tmp=QString(box->line());
		if ((c=tmp.find("::"))>0) tmp.remove(0,c+3);
		tmp.stripWhiteSpace();
		cb->setText(tmp.data());
		break;
	}
}


int main(int argc, char* argv[])
{

	KApplication *app=new KApplication(argc,argv);
	kdsing *locate=new kdsing;

	app->setMainWidget(locate);
	locate->show();

	app->exec();

	return(0);
}

