/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the Visual 'K' project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <vkwidget.h>
#include <vkwidget.moc>

/*****************************************************************************
	class vkWidget
******************************************************************************/
vkWidget::vkWidget( QWidget *parent, const char *name )
	: QWidget( parent, name )
{
int i;

	for ( i = 1; i < 100; i++ )
		child_ids[i] = 0;

	myParent = parent;
	isWindow = true;
	myID = 0; //==> not set, yet

	myName = "not_registered_yet";


	transferState = 0;
	transferList.s("");


} //constructor


vkWidget::vkWidget( vkWidget *parent, const char *name )
	: QWidget( parent, name )
{
	myParent = parent;
	isWindow = false;

	myID = 0; //==> not set, yet

	myName = "not_registered_yet";

	transferState = 0;
	transferList.s("");

} //constructor


//*****************************************************************


// Start a new 'postcard':

v vkWidget::sendPostCard( QString addressee, QString what,
	int how, QString argument )
{
int i, childId = 0;
QString tmpString;
QString checkString;
v ret;
bool childFound = FALSE;

	ret.s(""); // ret = ""; causes a segmentation fault

	if ( myName == "not_registered_yet" )
	{//Can't send postcards when not registered!

		debug ( "Visual 'K' internal runtime error:" );
		debug ( "ckWidget::sendPostcard(...) called before");
		debug ( "registration and error hirarchy were complete!");

		abort();
	}

	if ( addressee == myName ) addressee = ".";

	if ( addressee.left(1) == "." )
	{//This could be directly for me or a dependent child...

		if ( addressee == "." )
		{//For me

			if ( how == 1 ) //Read property/method
			{

				while ( transferState != 0 );
					//waiting for free
					//transferList

				transferState = -1; //Now, "occupated"

				doInstructions ( what,
					how, myName, 0 );

				while (!transferState);
					//until transferState
					//set to 1 (answer)

				ret = transferList;

				transferState = 0; //Now, it can be used again!

				return(ret);

			}
			else
			{
				doInstructions( what, how, argument, 0 );

				return(ret);
			}
		}
	
		//Make addressee absolute if not for me:
		addressee = QString ( (myName) +(addressee) );

		for ( i = 1; i < 100; i++ )
		{
			if ( childNames[i] == addressee )
			{//direct vkWidget child

				if ( how == 1 )
				{
					while ( transferState != 0 );
						//waiting for free
						//transferList

					transferState = -1; //Now, "occupated"

					emit ( childCall(i, addressee,
						what, how, myName) );

					while (!transferState);
						//until transferState
						//set to 1 (answer)

					ret = transferList;

					transferState = 0;
						//Now, it can be used again!

					return(ret);

				}
				else
				{// ==> how != 1

					emit ( childCall(i, addressee,
						what, how, argument) );

					return(ret);
				} //if ( how == 1 )

			} //if ( childNames[i] == addressee )

		}//for

		depChilds.resetCounter();

		for ( i = 100; i <= depChilds.maxIndex(); i++ )
		{//Or a dependent child ?

			depChilds.setCounter(i);

			if ( depChilds.actualChildName() == addressee )
			{//Yeah!

				if ( how == 1 )
				{
					while ( transferState != 0 );
						//waiting for free
						//transferList

					transferState = -1; //Now, "occupated"

					doInstructions ( what,
						how, myName, i );

					while (!transferState);
						//until transferState
						//set to 1 (answer)

					ret = transferList;

					transferState = 0;
						//Now, it can be used again!

					return(ret);

				}
				else
				{// ==> how != 1

					doInstructions ( what,
						how, argument, i );

					return(ret);
				} //if ( how == 1 )
			}//if
		}//for


	} //if ( addressee.left(1) == "." )


	//check whether this is own child or a strange one:
	if ( addressee.left( myName.length() ) == myName )
		// own child
	{

		// get name of _direct_ child:

		if ( addressee.find( '.', myName.length() )
			!= -1 )
		{ //Child

			if( addressee.find( '.', myName.length()+1 ) == -1 )
			{ //direct child
				tmpString = addressee;
			}
			else
			{ //indirect child

				tmpString = addressee.left(
					addressee.find( '.',
					myName.length()+1 ) );
			}

		}
		else
		{ //That's me
			debug( "VK library error; ablolute address wasn't transformed." );
			debug( "Please report this bug at <de_cp@linuxstart.com>. Thank you." );
			fatal( "Internal error in vkWidget::sendPostCard(...)" );
		}

		for ( i = 1; i < 100; i++ )
		{
			if ( childNames[i] == tmpString )
			{
				childId = child_ids[i];
				childFound = true;
				break;
			}

		}

		depChilds.resetCounter();

		for ( i = 100; i < depChilds.maxIndex(); i++ )
		{

			if ( childFound ) break;

			depChilds.setCounter(i);

			if ( depChilds.actualChildName() == addressee )
			{	//Needn't tmpString set here,
				//since dep. childs haven't any sub widgets!

				childId = i;
				childFound = true;

				break;
			}
		}

		if ( childFound )
		{
			if ( childId < 100 )
			{ //vkWidget child (independent)

				if ( how == 1 )
				{ //must wait for return value

					while ( transferState != 0 );
						//waiting for free
						//transferList

					transferState = -1;
						//Now, "occupated"

					emit ( childCall(childId,
						addressee, what, how,
						myName) );

					while (!transferState);
						//until transferState
						//set to 1 (answer)

					ret = transferList;

					transferState = 0;
						//Now, it can be used again!

					return(ret);

				}
				else
				{ // --> how != 1

					emit ( childCall
						( childId, addressee,
						what, how, argument ) );

				}

			}
			else
			{//==> dependent child

			debug ( "	CRITICAL: Don't know, whether I need to differ how == 1 and how != 2 " );

				while ( transferState != 0 );
					//waiting for free
					//transferList

				transferState = -1; //Now, "occupated"

				doInstructions ( what,
					how, myName, i );

				while (!transferState);
					//until transferState
					//set to 1 (answer)

				ret = transferList;

				transferState = 0;
					//Now, it can be used again!

				return(ret);

			}//if ( childId < 100 )

		}
		else
		{// ==> I haven't such a child

			emit ( parentCall( -1, "", "Error", 1,
				QString ("Call for a widget, ")
				+("which is not registered " )
				+("in vkWidget object.") )
			      );

			/* -1: Error
			   addressee: (none);
			   1: Error number
			   QString: Error text */
		}
	}
	else // ==> addressee is NOT an own child.
	{

		if ( how == 1 )
		{
			while ( transferState != 0 );
				//waiting for free transferList

			transferState = -1; //Now, "occupated"

			emit ( parentCall( 0, addressee, what,	
				how, argument ) );

			while (!transferState);
				//until transferState set to 1 (answer)

			ret = transferList;

			transferState = 0; //Now, it can be used again!

			return(ret);
		}
		else
		{
			emit ( parentCall( 0, addressee,
				what, how, argument ) );
		}

	} // end of else of if adressee is own child

	return(ret);

} //sendPostCard



void vkWidget::registerChild ( vkPushButton *newChild,
	const char *name )
{
//This is for _dependent_ widgets
bool checked;

	if ( myName != "not_registered_yet" )
		checked = depChilds.setNew( newChild,
			QString(myName)+(".") +(name) );
	else
		checked = depChilds.setNew( newChild, name );

	if ( !checked )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	// else registration complete!

} //registerChild ( vkPushButton, const char * )


void vkWidget::registerChild ( vkLabel *newChild,
	const char *name )
{
//This is for _dependent_ widgets
bool checked;

	if ( myName != "not_registered_yet" )
		checked = depChilds.setNew( newChild,
			QString(myName)+(".") +(name) );
	else
		checked = depChilds.setNew( newChild, name );

	if ( !checked )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	// else registration complete!

} //registerChild ( vkLabel, const char * )


void vkWidget::registerChild ( vkPixLabel *newChild,
	const char *name )
{
//This is for _dependent_ widgets
bool checked;

	if ( myName != "not_registered_yet" )
	{
		checked = depChilds.setNew( newChild,
			QString(myName)+(".") +(name) );
	}
	else
		checked = depChilds.setNew( newChild, name );

	if ( !checked )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	// else registration complete!

} //registerChild ( vkPixLabel, const char * )


void vkWidget::registerChild ( vkLineEdit *newChild,
	const char *name )
{
//This is for _dependent_ widgets
bool checked;


	if ( myName != "not_registered_yet" )
		checked = depChilds.setNew( newChild,
			QString(myName)+(".") +(name) );
	else
		checked = depChilds.setNew( newChild, name );


	if ( !checked )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	// else registration complete!

} //registerChild ( vkLineEdit, const char * )


void vkWidget::registerChild ( vkListBox *newChild,
	const char *name )
{
//This is for _dependent_ widgets
bool checked;

	if ( myName != "not_registered_yet" )
		checked = depChilds.setNew( newChild,
			QString(myName)+(".") +(name) );
	else
		checked = depChilds.setNew( newChild, name );

	if ( !checked )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	// else registration complete!

} //registerChild ( vkListBox, const char * )


void vkWidget::registerChild ( vkCheckBox *newChild,
	const char *name )
{
//This is for _dependent_ widgets
bool checked;

	if ( myName != "not_registered_yet" )
		checked = depChilds.setNew( newChild,
			QString(myName)+(".") +(name) );
	else
		checked = depChilds.setNew( newChild, name );

	if ( !checked )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	// else registration complete!

} //registerChild ( vkCheckBox, const char * )


void vkWidget::registerChild ( vkOptionButton *newChild,
	const char *name )
{
//This is for _dependent_ widgets
bool checked;

	if ( myName != "not_registered_yet" )
		checked = depChilds.setNew( newChild,
			QString(myName)+(".") +(name) );
	else
		checked = depChilds.setNew( newChild, name );

	connect( newChild, SIGNAL( uncheckOpts() ), SLOT( uncheckOpt() ) );

	if ( !checked )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	// else registration complete!

} //registerChild ( vkOptionButton, const char * )


void vkWidget::registerChild ( vkSlider *newChild,
	const char *name )
{
//This is for _dependent_ widgets
bool checked;

	if ( myName != "not_registered_yet" )
		checked = depChilds.setNew( newChild,
			QString(myName)+(".") +(name) );
	else
		checked = depChilds.setNew( newChild, name );

	if ( !checked )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	// else registration complete!

} //registerChild ( vkSlider, const char * )


void vkWidget::registerChild ( vkProcCtrl *newChild,
	const char *name )
{
//This is for _dependent_ widgets
bool checked;

	if ( myName != "not_registered_yet" )
		checked = depChilds.setNew( newChild,
			QString(myName)+(".") +(name) );
	else
		checked = depChilds.setNew( newChild, name );

	if ( !checked )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	// else registration complete!

} //registerChild ( vkProcCtrl, const char * )


void vkWidget::registerChild ( vkWidget *newChild,
	const char *name )
{
//this is for sub widgets

int i = 1;

	//looking for a free place:

	while( child_ids[i] != 0 )
		i++;

	if ( i == 99 )
	{
		// no place!
		emit ( parentCall( -1, "", "Error", 2,
			QString("Too many widgets in vkWidget ")
			+(myName)+ (" .") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	childs[i] = newChild;

	connect ( this, SIGNAL( initChild(int, QString, int) ),
		childs[i], SLOT( initMe( int, QString, int) ) );

	connect ( this, SIGNAL(
		childCall( int, QString, QString,
			int, QString ) ),
		childs[i], SLOT(
		postOffice( int, QString, QString,
			int, QString ) )
		);

	connect ( childs[i], SIGNAL(
		parentCall( int, QString, QString,
			int, QString ) ),
		this, SLOT(
		postOffice( int, QString, QString,
			int, QString ) )
		);

	child_ids[i] = i;

	if ( myName != "not_registered_yet" )
	{

		childNames[i] = QString( (myName)
			+(".") +(name) );

		emit (initChild (child_ids[i],
			childNames[i], 0) );
	}
	else
	{
		childNames[i] = name;

		emit (initChild (child_ids[i],
			"not_registered_yet", 0) );
	}

	emit ( loadMe() );

} // registerChild


void vkWidget::forgetChild ( const char *whichChild )
{
	debug ( "vkWidget::forgetChild(...) : Not implemented, yet!" );
}


//slots:

void vkWidget::initMe( int newID, QString newName,
	int forWhom ) //slot
{
int i;

	if ( forWhom != myID ) return; /* This is only
					for NEW widgets
					whose ID is still
					0 or for those
					which are explicitly
					addressed */
	myID = newID;

	//Reinit all allready existing childs with new name:
	for ( i = 1; i < 100; i++ )
	{
		if ( newName == "not_registered_yet" )
			break;

		if ( child_ids[i] != 0 )
		{

			childNames[i] = QString (newName)
				+(".") +(childNames[i]);

			emit( initChild( i,
				childNames[i], i ) );
		}

	}


	//Reinit dependent childs:

	depChilds.resetCounter();
	do
	{
		if ( newName == "not_registered_yet" )
			break;

		if ( depChilds.actualChildName() != "" )
		{
			depChilds.changeChildName( QString (newName)
				+(".") +(depChilds.actualChildName()) );
		}

	} while ( depChilds.nextChildName() != "" );


	myName = newName;

	if ( myName != "not_registered_yet" )
	{
		regComplete();
		start();
	}

}



void vkWidget::checkBool( QString *check )
{
v blc;
	blc.s( check->copy() );

	if( blc.b() )
		check->setStr( "TRUE" );
	else
		check->setStr( "FALSE" );
}


void vkWidget::checkInt( QString *check, bool allowNone )
{
bool ok;

	if( check->lower() == "(none)" )
	{
		if( allowNone )
		{
			check->setStr( check->lower() );
			return;
		}
		else
			emit ( parentCall( -1, "", "Error", 1,
				QString ("You tried to use \"(none)\" as ")
				+("property value for a property " )
				+("what doesn't take \"(none)\".") ) );
			
	}

	check->toInt( &ok );

	if( !ok )
		emit ( parentCall( -1, "", "Error", 1,
			QString ("This property expects an ")
			+("integer value." ) ) );


}


void vkWidget::checkColor( QString *check )
{
int i = 0;

	check->setStr( check->lower() );
	check->setStr( check->simplifyWhiteSpace() );

	while( !check->mid( i, 1 ).isNull() )
	{
		if( check->mid( i, 1 ) == " " )
			check->remove( i, 1 );


		// This check is incomplete: Check also, whether only '(', ')', ',' and numeric chars

		i++;
	}

}

void vkWidget::mouseReleaseEvent( QMouseEvent *e )
{
int x, y;

	x = e->x(); y = e->y();

	if ( e->button() == LeftButton
		&& x >= 0 && y >= 0 && x <= width() && y <= height() )
		click(); //Left-button-click in range
}

void vkWidget::doInstructions( QString what, int how,
	QString argument, int where )
{
QString answer;
int widType;

vkPushButton *ctrlButton;
vkLabel *ctrlLabel;
vkPixLabel *ctrlPLabel;
vkLineEdit *ctrlLineEdit;
vkListBox *ctrlLB;
vkCheckBox *ctrlCB;
vkOptionButton *ctrlOpt;
vkSlider *ctrlSl;
vkProcCtrl *ctrlProc;


	// 0) If our instruction is just an answer, we can leave here!
	if ( how == 2 ) //returning answer
	{
		transferList.s(argument); //argument is the answer

		transferState = 1;

		return;

	} // if ( how == 2 )

	// 1) (how!=2) Control whether property/method is avaible:
	if ( where < 100 )
	{
		widType = 0; //vkWidget
	}
	else
	{
		depChilds.setCounter(where);

		switch( depChilds.childType() )
		{
			case 1: //vkPushButton;
				widType = 1;
				break;

			case 2: //vkLabel
				widType = 2;
				break;

			case 3: //vkLineEdit
				widType = 3;
				break;

			case 4: //vkListBox
				widType = 4;
				break;

			case 5: //vkCheckBox
				widType = 5;
				break;

			case 6: //vkOptionButton
				widType = 6;
				break;

			case 7: //vkSlider
				widType = 7;
				break;

			case 8: //vkPixLabel
				widType = 8;
				break;

			case 9: //vkProcCtrl
				widType = 9;
				break;

			default:
				//Error:
				emit ( parentCall( -1, "", "Error", 1,
					QString ("Internal VK error ")
					+("(childList::childType() " )
					+("returned invalid widget type).") )
				);
		}//switch

	}//if  ( where < 100 )

	//is the property avaible ?:

	what = what.lower();

	if ( what == "caption" )
	{
		//Avaible for (nearly) all widgets
		if( widType == 0 && (!isWindow || where != 0) )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Caption\" is not " )
				+("avaible for sub windows).") ) );

		if( widType == 4 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Caption\" is not " )
				+("avaible for list boxes).") ) );

		if( widType == 7 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Caption\" is not " )
				+("avaible for slider widgets).") ) );

		if( widType == 8 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Caption\" is not " )
				+("avaible for pixmap labels).") ) );
	}
	else if ( what == "enabled" )
	{
		//For (nearly) every widget:
		if (how==0) checkBool( &argument );

		if ( widType == 0 || widType == 2 || widType == 8 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Enabled\" is not " )
				+("avaible for (sub)windows and labels. ") ) );

		if ( widType == 9 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Enabled\" is not " )
				+("avaible for process control widgets).") ) );
	}
	else if ( what == "visible" )
	{
		if (how==0) checkBool( &argument );
		//Avaible for all widgets
	}
	else if ( what == "width" )
	{
		if (how==0) checkInt( &argument );
		//Avaible for all widgets
	}
	else if ( what == "height" )
	{
		if (how==0) checkInt( &argument );
		//Avaible for all widgets
	}
	else if ( what == "x" )
	{
		if (how==0) checkInt( &argument );

		if( isWindow && where == 0 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"X\" is not " )
				+("avaible for windows).") ) );

	}
	else if ( what == "y" )
	{
		if (how==0) checkInt( &argument );

		if( isWindow && where == 0 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Y\" is not " )
				+("avaible for windows).") ) );
	}
	else if ( what == "checked" )
	{

		if( widType != 5 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Checked\" is only avaible " )
				+("for check boxes).") ) );
	}
	else if ( what == "checkedexclusive" )
	{

		if( widType != 6 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"CheckedExclusive\" is only avaible " )
				+("for option buttons).") ) );
	}
	else if ( what == "steps" )
	{

		if( widType != 7 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Steps\" is only avaible " )
				+("for sliders).") ) );
	}
	else if ( what == "value" )
	{

		if( widType != 7 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Value\" is only avaible " )
				+("for sliders).") ) );
	}
	else if ( what == "autosort" )
	{

		if ( widType != 4 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"AutoSort\" is not " )
				+("avaible for other widgets than ")
				+("list boxes).") ) );

	}
	else if ( what == "minimalwidth" )
	{
		if (how==0) checkInt( &argument );

		if( !isWindow || where != 0 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"MinimalWidth\" is not " )
				+("avaible for widgets other than windows).") ) );
	}
	else if ( what == "minimalheight" )
	{
		if (how==0) checkInt( &argument );

		if( !isWindow || where != 0 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"MinimalHeight\" is not " )
				+("avaible for widgets other than windows).") ) );
	}
	else if ( what == "maximalwidth" )
	{
		if (how==0) checkInt( &argument, true );

		if( !isWindow || where != 0 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"MaximalWidth\" is not " )
				+("avaible for widgets other than windows).") ) );
	}
	else if ( what == "maximalheight" )
	{
		if (how==0) checkInt( &argument, true );

		if( !isWindow || where != 0 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"MaximalHeight\" is not " )
				+("avaible for widgets other than windows).") ) );
	}
	else if ( what == "backgroundcolor" )
	{
		if (how==0) checkColor( &argument );

		if( widType != 0 && widType != 2 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"BackgroundColor\" is only " )
				+("avaible for (sub) windows and labels).") ) );
	}
	else if ( what == "picture" )
	{

		if ( widType != 8 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Picture\" is not " )
				+("avaible for other widgets than ")
				+("pixmap labels).") ) );

	}
	else if ( what == "command" )
	{

		if ( widType != 9 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Command\" is not " )
				+("avaible for other widgets than ")
				+("process controls).") ) );
	}
	else if ( what == "arguments" )
	{

		if ( widType != 9 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Arguments\" is not " )
				+("avaible for other widgets than ")
				+("process controls).") ) );

	}
	else if ( what == "running" )
	{

		if ( widType != 9 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"Running\" is not " )
				+("avaible for other widgets than ")
				+("process controls).") ) );

	}
	else if ( what == "returnval" )
	{

		if ( widType != 9 )
			emit ( parentCall( -1, "", "Error", 1,
				QString ("Programmers mistake ")
				+("(Property \"ReturnVal\" is not " )
				+("avaible for other widgets than ")
				+("process controls).") ) );

	}
	else
	{
		//Error:
		emit ( parentCall( -1, "", "Error", 1,
			QString ("Property \"")
			+(what) +("\" unknown !") ) );
	}


	// 2) Instruction:

	if ( how == 1 ) //READ
	{

		//read the property:

		if ( what == "caption" ) //Property
		{

			if ( where == 0 )
			{
				answer = caption();
			}
			else
			{ //Child:

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{
					case 1: //vkPushButton
						ctrlButton=depChilds.getButton();
						answer = ctrlButton->text();

						break;

					case 2: //vkLabel
						ctrlLabel=depChilds.getLabel();
						answer = ctrlLabel->text();

						break;

					case 3: //vkLineEdit
						ctrlLineEdit=depChilds.getLineEdit();
						answer = ctrlLineEdit->text();

						break;

					case 5: //vkCheckBox
						ctrlCB=depChilds.getCheckBox();
						answer = ctrlCB->text();

						break;

					case 6: //vkOptionButton
						ctrlOpt=depChilds.getOptionButton();
						answer = ctrlOpt->text();

						break;

					case 9: //vkProcControl
						ctrlProc=depChilds.getProc();
						answer = ctrlProc->text();

						break;

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )


		} //if ( what == "caption" )


		if ( what == "enabled" )
		{
			if( where != 0 )
			{
				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{
					case 1: //vkPushButton
						ctrlButton=depChilds.getButton();

						
						if( ctrlButton->isEnabled() )
							answer = "TRUE";
						else
							answer = "FALSE";

						break;

					case 3: //vkLineEdit
						ctrlLineEdit=depChilds.getLineEdit();

						if( ctrlLineEdit->isEnabled() )
							answer = "TRUE";
						else
							answer = "FALSE";

						break;

					case 4: //vkListBox
						ctrlLB=depChilds.getListBox();

						if ( ctrlLB->isEnabled() )
							answer = "TRUE";
						else
							answer = "FALSE";
						break;


					case 5: //vkCheckBox
						ctrlCB=depChilds.getCheckBox();

						if ( ctrlCB->isEnabled() )
							answer = "TRUE";
						else
							answer = "FALSE";
						break;


					case 6: //vkOptionButton
						ctrlOpt=depChilds.getOptionButton();

						if ( ctrlOpt->isEnabled() )
							answer = "TRUE";
						else
							answer = "FALSE";
						break;

					case 7: //vkSlider
						ctrlSl=depChilds.getSlider();

						if( ctrlSl->isEnabled() )
							answer = "TRUE";
						else
							answer = "FALSE";

						break;

					default: //Ignore error...
						break;
				}

			}//else ignore error


		} //if ( what == "enabled" )

 		if ( what == "visible" )
	 	{
 			if ( where == 0 )
	 		{
				if( isVisible() )
					answer = "TRUE";
				else
					answer = "FALSE";
 			}
 			else
	 		{ //Child:

 				depChilds.setCounter(where);

 				switch( depChilds.childType() )
	 			{
 					case 1: //QPushButton
 						ctrlButton=depChilds.getButton();

 						if ( ctrlButton->isVisible() )
 							answer = "TRUE";
 						else
 							answer = "FALSE";

 						break;

 					case 2: //vkLabel
 						ctrlLabel=depChilds.getLabel();

 						if ( ctrlLabel->isVisible() )
 							answer = "TRUE";
	 					else
 							answer = "FALSE";

 						break;

 					case 3: //vkLineEdit
 						ctrlLineEdit=depChilds.getLineEdit();

 						if ( ctrlLineEdit->isVisible() )
 							answer = "TRUE";
	 					else
 							answer = "FALSE";

 						break;

 					case 4: //vkListBox
 						ctrlLB=depChilds.getListBox();

 						if ( ctrlLB->isVisible() )
	 						answer = "TRUE";
	 					else
 							answer = "FALSE";

 						break;

 					case 5: //vkCheckBox
 						ctrlCB=depChilds.getCheckBox();

 						if ( ctrlCB->isVisible() )
	 						answer = "TRUE";
	 					else
 							answer = "FALSE";

 						break;

 					case 6: //vkOptionButton
 						ctrlOpt=depChilds.getOptionButton();

 						if ( ctrlOpt->isVisible() )
	 						answer = "TRUE";
	 					else
 							answer = "FALSE";

 						break;

 					case 7: //vkSlider
 						ctrlSl=depChilds.getSlider();

 						if ( ctrlSl->isVisible() )
	 						answer = "TRUE";
	 					else
 							answer = "FALSE";

 						break;


 					case 8: //vkPixLabel
 						ctrlPLabel=depChilds.getPLabel();

 						if ( ctrlPLabel->isVisible() )
	 						answer = "TRUE";
	 					else
 							answer = "FALSE";

 						break;

 					case 9: //vkProcCtrl
 						ctrlProc=depChilds.getProc();

 						if ( ctrlProc->isVisible() )
	 						answer = "TRUE";
	 					else
 							answer = "FALSE";

 						break;


 					default:
 						//Error
 						break;

 				} //switch

 			} //else ( if (where==0) )

		} //if ( what == "visible" )

		if ( what == "width" )
		{
			if ( where == 0 )
			{
				answer.setNum(width());
			}
			else
			{ //Child:

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{
					case 1: //vkPushButton
						ctrlButton=depChilds.getButton();

						answer.setNum(ctrlButton->width());

						break;

					case 2: //vkLabel
						ctrlLabel=depChilds.getLabel();

						answer.setNum(ctrlLabel->width());

						break;

					case 3: //vkLineEdit
						ctrlLineEdit=depChilds.getLineEdit();

						answer.setNum(ctrlLineEdit->width());

						break;

					case 4: //vkListBox
						ctrlLB=depChilds.getListBox();

						answer.setNum(ctrlLB->width());

						break;

					case 5: //vkCheckBox
						ctrlCB=depChilds.getCheckBox();

						answer.setNum(ctrlCB->width());

						break;

					case 6: //vkOptionButton
						ctrlOpt=depChilds.getOptionButton();

						answer.setNum(ctrlOpt->width());

						break;

					case 7: //vkSlider
						ctrlSl=depChilds.getSlider();

						answer.setNum(ctrlSl->width());

						break;

					case 8: //vkPixLabel
						ctrlPLabel=depChilds.getPLabel();

						answer.setNum(ctrlPLabel->width());

						break;

					case 9: //vkProcCtrl
						ctrlProc=depChilds.getProc();

						answer.setNum(ctrlProc->width());

						break;

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "width" )

		if ( what == "height" )
		{
			if ( where == 0 )
			{
				answer.setNum(height());
			}
			else
			{ //Child:

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{
					case 1: //vkPushButton
						ctrlButton=depChilds.getButton();

						answer.setNum(ctrlButton->height());

						break;

					case 2: //vkLabel
						ctrlLabel=depChilds.getLabel();

						answer.setNum(ctrlLabel->height());

						break;


					case 3: //vkLineEdit
						ctrlLineEdit=depChilds.getLineEdit();

						answer.setNum(ctrlLineEdit->height());

						break;

					case 4: //vkListBox
						ctrlLB=depChilds.getListBox();

						answer.setNum(ctrlLB->height());

						break;

					case 5: //vkCheckBox
						ctrlCB=depChilds.getCheckBox();

						answer.setNum(ctrlCB->height());

						break;

					case 6: //vkOptionButton
						ctrlOpt=depChilds.getOptionButton();

						answer.setNum(ctrlOpt->height());

						break;

					case 7: //vkSlider
						ctrlSl=depChilds.getSlider();

						answer.setNum(ctrlSl->height());

						break;

					case 8: //vkPixLabel
						ctrlPLabel=depChilds.getPLabel();

						answer.setNum(ctrlPLabel->height());

						break;

					case 9: //vkSlider
						ctrlProc=depChilds.getProc();

						answer.setNum(ctrlProc->height());

						break;

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "height" )

		if ( what == "x" )
		{
			if ( where == 0 )
			{
				answer.setNum(x());
				//Or error, if this is a window, not a sub widget!
			}
			else
			{ //Child:

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{
					case 1: //vkPushButton
						ctrlButton=depChilds.getButton();

						answer.setNum(ctrlButton->x());

						break;

					case 2: //vkLabel
						ctrlLabel=depChilds.getLabel();

						answer.setNum(ctrlLabel->x());

						break;

					case 3: //vkLineEdit
						ctrlLineEdit=depChilds.getLineEdit();

						answer.setNum(ctrlLineEdit->x());

						break;

					case 4: //vkListBox
						ctrlLB=depChilds.getListBox();

						answer.setNum(ctrlLB->x());

						break;

					case 5: //vkCheckBox
						ctrlCB=depChilds.getCheckBox();

						answer.setNum(ctrlCB->x());

						break;

					case 6: //vkOptionButton
						ctrlOpt=depChilds.getOptionButton();

						answer.setNum(ctrlOpt->x());

						break;

					case 7: //vkSlider
						ctrlSl=depChilds.getSlider();

						answer.setNum(ctrlSl->x());

						break;

					case 8: //vkPixLabel
						ctrlPLabel=depChilds.getPLabel();

						answer.setNum(ctrlPLabel->x());

						break;

					case 9: //vkSlider
						ctrlProc=depChilds.getProc();

						answer.setNum(ctrlProc->x());

						break;

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "x" )

		if ( what == "y" )
		{
			if ( where == 0 )
			{
				answer.setNum(y());
				//Or error, if this is a window, not a sub widget!
			}
			else
			{ //Child:

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{
					case 1: //vkPushButton
						ctrlButton=depChilds.getButton();

						answer.setNum(ctrlButton->y());

						break;

					case 2: //vkLabel
						ctrlLabel=depChilds.getLabel();

						answer.setNum(ctrlLabel->y());

						break;

					case 3: //vkLineEdit
						ctrlLineEdit=depChilds.getLineEdit();

						answer.setNum(ctrlLineEdit->y());

						break;

					case 4: //vkListBox
						ctrlLB=depChilds.getListBox();

						answer.setNum(ctrlLB->y());

						break;

					case 5: //vkCheckBox
						ctrlCB=depChilds.getCheckBox();

						answer.setNum(ctrlCB->y());

						break;

					case 6: //vkOptionButton
						ctrlOpt=depChilds.getOptionButton();

						answer.setNum(ctrlOpt->y());

						break;

					case 7: //vkSlider
						ctrlSl=depChilds.getSlider();

						answer.setNum(ctrlSl->y());

						break;

					case 8: //vkPixLabel
						ctrlPLabel=depChilds.getPLabel();

						answer.setNum(ctrlPLabel->y());

						break;

					case 9: //vkSlider
						ctrlProc=depChilds.getProc();

						answer.setNum(ctrlProc->y());

						break;

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "y" )

		if ( what == "autosort" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 4: //vkListBox
						ctrlLB=depChilds.getListBox();


						if(ctrlLB->isSorted())
							answer = "TRUE";
						else
							answer = "FALSE";

						break;

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "autosort" )

		if ( what == "checked" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 5: //vkCheckBox
						ctrlCB=depChilds.getCheckBox();


						if(ctrlCB->isChecked())
							answer = "TRUE";
						else
							answer = "FALSE";

						break;

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "checked" )

		if ( what == "checkedexclusive" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 6: //vkOptionButton
						ctrlOpt=depChilds.getOptionButton();

						if(ctrlOpt->isChecked())
							answer = "TRUE";
						else
							answer = "FALSE";

						break;

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "checkedexclusive" )

		if ( what == "steps" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 7: //vkSlider
						ctrlSl=depChilds.getSlider();

						answer.setNum(ctrlSl->maxValue());

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "steps" )

		if ( what == "value" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 7: //vkSlider
						ctrlSl=depChilds.getSlider();

						answer.setNum(ctrlSl->value());

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "value" )

		if ( what == "minimalwidth" )
		{
			if ( where == 0 )
			{
				answer.setNum( minimumSize().width() );
			}
			// else ignore error

		} //if ( what == "minimalwidth" )

		if ( what == "minimalheight" )
		{
			if ( where == 0 )
			{
				answer.setNum( minimumSize().height() );
			}
			// else ignore error

		} //if ( what == "minimalheight" )

		if ( what == "maximalwidth" )
		{
			if ( where == 0 )
			{
				answer.setNum( maximumSize().width() );
			}

		} //if ( what == "maximalwidth" )


		if ( what == "maximalheight" )
		{
			if ( where == 0 )
			{
				answer.setNum( maximumSize().height() );
			}
			// else ignore error

		} //if ( what == "maximalheight" )

		if ( what == "backgroundcolor" )
		{
			QString r, g, b;

			if ( where == 0 )
			{
				r.setNum(backgroundColor().red());
				g.setNum(backgroundColor().green());
				b.setNum(backgroundColor().blue());

				answer = QString ( "(" +r +"," +g +"," +b +")" );
			}
			else
			{ //Child:

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 2: //vkLabel
						ctrlLabel=depChilds.getLabel();

						r.setNum(ctrlLabel->backgroundColor().red());
						g.setNum(ctrlLabel->backgroundColor().green());
						b.setNum(ctrlLabel->backgroundColor().blue());

						answer = QString ( "(" +r +"," +g +"," +b +")" );

						break;

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "backgroundcolor" )


		if ( what == "picture" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 8: //vkPixLabel
						ctrlPLabel=depChilds.getPLabel();

						answer = ctrlPLabel->pixName();

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "picture" )


		if ( what == "command" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 9: //vkProcCtrl
						ctrlProc=depChilds.getProc();

						answer = ctrlProc->commandName();

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "command" )


		if ( what == "arguments" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 9: //vkProcCtrl
						ctrlProc=depChilds.getProc();

						answer = ctrlProc->commandArgs();

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "arguments" )


		if ( what == "running" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 9: //vkProcCtrl
						ctrlProc=depChilds.getProc();

						if( ctrlProc->isRunning() )
							answer = "TRUE";
						else
							answer = "FALSE";

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "arguments" )


		if ( what == "returnval" )
		{
			if ( where == 0 )
			{
				//ignore error
			}
			else
			{

				depChilds.setCounter(where);

				switch( depChilds.childType() )
				{

					case 9: //vkProcCtrl
						ctrlProc=depChilds.getProc();

						answer.setNum(ctrlProc->ret());

					default:
						//Error
						break;

				} //switch

			} //else ( if (where==0) )

		} //if ( what == "arguments" )


		sendPostCard ( argument, "answer", 2, answer );

		return;

	} //if ( how == 1 )



	// Our job is to change a property or run a void method (how == 0):

	if ( what == "caption" ) //Property
	{

		if ( where == 0 )
		{
			emit( parProp( "caption", argument ) );
			setCaption( argument ); //Just to make it readable
		}
		else
		{ //Child:

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{
				case 1: //vkPushButton
					ctrlButton=depChilds.getButton();
					ctrlButton->setText( argument );

					break;

				case 2: //vkLabel
					ctrlLabel=depChilds.getLabel();
					ctrlLabel->setText( argument );

					break;

				case 3: //vkLineEdit
					ctrlLineEdit=depChilds.getLineEdit();
					ctrlLineEdit->setText( argument );

					break;

				case 5: //vkCheckBox
					ctrlCB=depChilds.getCheckBox();
					ctrlCB->setText( argument );

					break;

				case 6: //vkOptionButton
					ctrlOpt=depChilds.getOptionButton();
					ctrlOpt->setText( argument );

					break;

				case 9: //vkProcCtrl
					ctrlProc=depChilds.getProc();
					ctrlProc->ts( argument );

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

		return;

	} //if ( what == "caption" )

	if ( what == "enabled" )
	{
		if( where != 0 )
		{
			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{
				case 1: //vkPushButton
					ctrlButton=depChilds.getButton();

					if ( argument == "TRUE" )
						ctrlButton->setEnabled(true);
					else
						ctrlButton->setEnabled(false);

					break;

				case 3: //vkLineEdit
					ctrlLineEdit=depChilds.getLineEdit();

					if ( argument == "TRUE" )
						ctrlLineEdit->setEnabled(true);
					else
						ctrlLineEdit->setEnabled(false);

					break;

				case 4: //vkListBox
					ctrlLB=depChilds.getListBox();

					if ( argument == "TRUE" )
						ctrlLB->setEnabled(true);
					else
						ctrlLB->setEnabled(false);
					break;

				case 5: //vkCheckBox
					ctrlCB=depChilds.getCheckBox();

					if ( argument == "TRUE" )
						ctrlCB->setEnabled(true);
					else
						ctrlCB->setEnabled(false);
					break;

				case 6: //vkOptionButton
					ctrlOpt=depChilds.getOptionButton();

					if ( argument == "TRUE" )
						ctrlOpt->setEnabled(true);
					else
						ctrlOpt->setEnabled(false);
					break;


				case 7: //vkSlider
					ctrlSl=depChilds.getSlider();

					if ( argument == "TRUE" )
						ctrlSl->setEnabled(true);
					else
						ctrlSl->setEnabled(false);
					break;

				default: //Ignore error...
					break;
			}

		}//else ignore error


	} //if ( what == "enabled" )

	if ( what == "visible" )
	{
		if ( where == 0 )
		{
			if ( argument == "TRUE" )
				show();
			else
				hide();

		}
		else
		{ //Child:

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{
				case 1: //QPushButton
					ctrlButton=depChilds.getButton();

					if ( argument == "TRUE" )
						ctrlButton->show();
					else
						ctrlButton->hide();

					break;

				case 2: //vkLabel
					ctrlLabel=depChilds.getLabel();

					if ( argument == "TRUE" )
						ctrlLabel->show();
					else
						ctrlLabel->hide();

					break;

				case 3: //vkLineEdit
					ctrlLineEdit=depChilds.getLineEdit();

					if ( argument == "TRUE" )
						ctrlLineEdit->show();
					else
						ctrlLineEdit->hide();

					break;

				case 4: //vkListBox
					ctrlLB=depChilds.getListBox();

					if ( argument == "TRUE" )
						ctrlLB->show();
					else
						ctrlLB->hide();

					break;

				case 5: //vkCheckBox
					ctrlCB=depChilds.getCheckBox();

					if ( argument == "TRUE" )
						ctrlCB->show();
					else
						ctrlCB->hide();
					break;

				case 6: //vkOptionButton
					ctrlOpt=depChilds.getOptionButton();

					if ( argument == "TRUE" )
						ctrlOpt->show();
					else
						ctrlOpt->hide();
					break;


				case 7: //vkSlider
					ctrlSl=depChilds.getSlider();

					if ( argument == "TRUE" )
						ctrlSl->show();
					else
						ctrlSl->hide();
					break;


				case 8: //vkPixLabel
					ctrlPLabel=depChilds.getPLabel();

					if ( argument == "TRUE" )
						ctrlPLabel->show();
					else
						ctrlPLabel->hide();
					break;

				case 9: //vkProcCtrl
					ctrlProc=depChilds.getProc();

					if ( argument == "TRUE" )
						ctrlProc->show();
					else
						ctrlProc->hide();
					break;


				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "visible" )


	if ( what == "width" )
	{
		if ( where == 0 )
		{
			emit( parProp( "width", argument ) );
		}
		else
		{ //Child:

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{
				case 1: //vkPushButton
					ctrlButton=depChilds.getButton();

					ctrlButton->resize(
						argument.toInt(), ctrlButton->height() );

					break;

				case 2: //vkLabel
					ctrlLabel=depChilds.getLabel();

					ctrlLabel->resize(
						argument.toInt(), ctrlLabel->height() );

					break;

				case 3: //vkLineEdit
					ctrlLineEdit=depChilds.getLineEdit();

					ctrlLineEdit->resize(
						argument.toInt(), ctrlLineEdit->height() );

					break;

				case 4: //vkListBox
					ctrlLB=depChilds.getListBox();

					ctrlLB->resize(
						argument.toInt(), ctrlLB->height() );

					break;

				case 5: //vkCheckBox
					ctrlCB=depChilds.getCheckBox();

					ctrlCB->resize(
						argument.toInt(), ctrlCB->height() );

					break;

				case 6: //vkOptionButton
					ctrlOpt=depChilds.getOptionButton();

					ctrlOpt->resize(
						argument.toInt(), ctrlOpt->height() );

					break;

				case 7: //vkSlider
					ctrlSl=depChilds.getSlider();

					ctrlSl->resize(
						argument.toInt(), ctrlSl->height() );

					break;

				case 8: //vkPixLabel
					ctrlPLabel=depChilds.getPLabel();

					ctrlPLabel->resize(
						argument.toInt(), ctrlPLabel->height() );

					break;

				case 9: //vkProcCtrl
					ctrlProc=depChilds.getProc();

					ctrlProc->resize(
						argument.toInt(), ctrlProc->height() );

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "width" )

	if ( what == "height" )
	{
		if ( where == 0 )
		{
			emit( parProp( "height", argument ) );
		}
		else
		{ //Child:

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{
				case 1: //vkPushButton
					ctrlButton=depChilds.getButton();

					ctrlButton->resize(
						ctrlButton->width(), argument.toInt() );

					break;

				case 2: //vkLabel
					ctrlLabel=depChilds.getLabel();

					ctrlLabel->resize(
						ctrlLabel->width(), argument.toInt() );

					break;


				case 3: //vkLineEdit
					ctrlLineEdit=depChilds.getLineEdit();

					ctrlLineEdit->resize(
						ctrlLineEdit->width(), argument.toInt() );

					break;

				case 4: //vkListBox
					ctrlLB=depChilds.getListBox();

					ctrlLB->resize(
						ctrlLB->width(), argument.toInt() );

					break;

				case 5: //vkCheckBox
					ctrlCB=depChilds.getCheckBox();

					ctrlCB->resize(
						ctrlCB->width(), argument.toInt() );

					break;

				case 6: //vkOptionButton
					ctrlOpt=depChilds.getOptionButton();

					ctrlOpt->resize(
						ctrlOpt->width(), argument.toInt() );

					break;

				case 7: //vkSlider
					ctrlSl=depChilds.getSlider();

					ctrlSl->resize(
						ctrlSl->width(), argument.toInt() );

					break;

				case 8: //vkPixLabel
					ctrlPLabel=depChilds.getPLabel();

					ctrlPLabel->resize(
						ctrlPLabel->width(), argument.toInt() );

					break;

				case 9: //vkProcCtrl
					ctrlProc=depChilds.getProc();

					ctrlProc->resize(
						 ctrlProc->width(), argument.toInt() );

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "height" )

	if ( what == "x" )
	{
		if ( where == 0 )
		{
			move( argument.toInt(), y() );
			//Or error, if this is a window, not a sub widget!
		}
		else
		{ //Child:

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{
				case 1: //vkPushButton
					ctrlButton=depChilds.getButton();

					ctrlButton->move(
						argument.toInt(), ctrlButton->y() );

					break;

				case 2: //vkLabel
					ctrlLabel=depChilds.getLabel();

					ctrlLabel->move(
						argument.toInt(), ctrlLabel->y() );

					break;

				case 3: //vkLineEdit
					ctrlLineEdit=depChilds.getLineEdit();

					ctrlLineEdit->move(
						argument.toInt(), ctrlLineEdit->y() );

					break;


				case 4: //vkListBox
					ctrlLB=depChilds.getListBox();

					ctrlLB->move(
						argument.toInt(), ctrlLB->y() );

					break;

				case 5: //vkCheckBox
					ctrlCB=depChilds.getCheckBox();

					ctrlCB->move(
						argument.toInt(), ctrlCB->y() );

					break;

				case 6: //vkOptionButton
					ctrlOpt=depChilds.getOptionButton();

					ctrlOpt->move(
						argument.toInt(), ctrlOpt->y() );

					break;

				case 7: //vkSlider
					ctrlSl=depChilds.getSlider();

					ctrlSl->move(
						argument.toInt(), ctrlSl->y() );

					break;

				case 8: //vkPixLabel
					ctrlPLabel=depChilds.getPLabel();

					ctrlPLabel->move(
						 argument.toInt(), ctrlPLabel->y() );

					break;

				case 9: //vkProcCtrl
					ctrlProc=depChilds.getProc();

					ctrlProc->move(
						 argument.toInt(), ctrlProc->y() );

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "x" )

	if ( what == "y" )
	{
		if ( where == 0 )
		{
			move( x(), argument.toInt() );
			//Or error, if this is a window, not a sub widget!
		}
		else
		{ //Child:

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{
				case 1: //vkPushButton
					ctrlButton=depChilds.getButton();

					ctrlButton->move(
						ctrlButton->x(), argument.toInt() );

					break;

				case 2: //vkLabel
					ctrlLabel=depChilds.getLabel();

					ctrlLabel->move(
						ctrlLabel->x(), argument.toInt() );

					break;

				case 3: //vkLineEdit
					ctrlLineEdit=depChilds.getLineEdit();

					ctrlLineEdit->move(
						ctrlLineEdit->x(), argument.toInt() );

					break;

				case 4: //vkListBox
					ctrlLB=depChilds.getListBox();

					ctrlLB->move(
						ctrlLB->x(), argument.toInt() );

					break;

				case 5: //vkCheckBox
					ctrlCB=depChilds.getCheckBox();

					ctrlCB->move(
						ctrlCB->x(), argument.toInt() );

					break;

				case 6: //vkOptionButton
					ctrlOpt=depChilds.getOptionButton();

					ctrlOpt->move(
						ctrlOpt->x(), argument.toInt() );

					break;

				case 7: //vkSlider
					ctrlSl=depChilds.getSlider();

					ctrlSl->move(
						ctrlSl->x(), argument.toInt() );

					break;

				case 8: //vkPixLabel
					ctrlPLabel=depChilds.getPLabel();

					ctrlPLabel->move(
						ctrlPLabel->x(), argument.toInt() );

					break;

				case 9: //vkProcCtrl
					ctrlProc=depChilds.getProc();

					ctrlProc->move(
						 ctrlProc->x(), argument.toInt() );

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "y" )

	if ( what == "autosort" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 4: //vkListBox
					ctrlLB=depChilds.getListBox();

					if ( argument == "TRUE" )
						ctrlLB->setAutoSort(true);
					else
						ctrlLB->setAutoSort(false);

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "autosort" )

	if ( what == "checked" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 5: //vkCheckBox
					ctrlCB=depChilds.getCheckBox();

					if ( argument == "TRUE" )
						ctrlCB->setChecked(true);
					else
						ctrlCB->setChecked(false);

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "checked" )

	if ( what == "checkedexclusive" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 6: //vkOptionButton
					ctrlOpt=depChilds.getOptionButton();

					if ( argument == "TRUE" )
						ctrlOpt->setChecked(true);
					else
						ctrlOpt->setChecked(false);

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "checkedexclusive" )

	if ( what == "steps" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 7: //vkOptionButton
					ctrlSl=depChilds.getSlider();

					ctrlSl->setRange( 0, argument.toInt() );

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "steps" )

	if ( what == "value" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 7: //vkOptionButton
					ctrlSl=depChilds.getSlider();

					ctrlSl->setValue( argument.toInt() );

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "checkedexclusive" )

	if ( what == "minimalwidth" )
	{
		if ( where == 0 )
		{
			setMinimumWidth( argument.toInt() );
		}
		// else ignore error


	} //if ( what == "minimalwidth" )

	if ( what == "minimalheight" )
	{
		if ( where == 0 )
		{
			setMinimumHeight( argument.toInt() );
		}
		// else ignore error


	} //if ( what == "minimalheight" )

	if ( what == "maximalwidth" )
	{
		if ( where == 0 && argument != "(none)" )
		{
			setMaximumWidth( argument.toInt() );
		}


	} //if ( what == "maximalwidth" )

	if ( what == "maximalheight" && argument != "(none)" )
	{
		if ( where == 0 )
		{
			setMaximumHeight( argument.toInt() );
		}
		// else ignore error


	} //if ( what == "maximalheight" )

	if ( what == "backgroundcolor" )
	{
		debug( "ARGUMENT INPUT (RGB): %s", (const char *)argument );

		QString r(4), g(4), b(4);
		int iBG = 0, intP = 0;

		for( iBG = 1; argument[iBG] != ','; iBG++ )
		{
			if ( argument[iBG] == 0L ) emit ( parentCall( -1, "",
				"Error", 1, QString ("Property \"BackgroundColor\"'")
				+("' has wrong value format !") ) );

			r[intP] = argument[iBG];
			intP++;
		}

		r[intP] = 0L;

		iBG++; intP = 0;

		while( argument[iBG] != ',' )
		{
			if ( argument[iBG] == 0L ) emit ( parentCall( -1, "",
				"Error", 1, QString ("Property \"BackgroundColor\"'")
				+("' has wrong value format !") ) );

			g[intP] = argument[iBG];

			intP++;
			iBG++;
		}

		g[intP] = 0L;

		iBG++; intP = 0;

		while( argument[iBG] != ')' )
		{
			if ( argument[iBG] == 0L ) emit ( parentCall( -1, "",
				"Error", 1, QString ("Property \"BackgroundColor\"'")
				+("' has wrong value format !") ) );

			b[intP] = argument[iBG];

			intP++;
			iBG++;
		}

		b[intP] = 0L;

		debug ( "Got RGB value (%d,%d,%d) ...", r.toInt(), g.toInt(), b.toInt() );
		if ( where == 0 )
		{
			setPalette( QColor( r.toInt(), g.toInt(), b.toInt() ) );
		}
		else
		{ //Child:

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 2: //vkLabel
					ctrlLabel=depChilds.getLabel();

					ctrlLabel->setPalette( QColor( r.toInt(),
						g.toInt(), b.toInt() ) );

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "backgroundcolor" )

	if ( what == "picture" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 8: //vkPixLabel
					ctrlPLabel=depChilds.getPLabel();

					ctrlPLabel->loadPic(argument);

				break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "picture" )

	if ( what == "command" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 9: //vkProcCtrl
					ctrlProc=depChilds.getProc();

					ctrlProc->setCommand(argument);

				break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "command" )

	if ( what == "arguments" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 9: //vkProcCtrl
					ctrlProc=depChilds.getProc();

					ctrlProc->setArgs(argument);

				break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "arguments" )

	if ( what == "running" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 9: //vkProcCtrl
					ctrlProc=depChilds.getProc();

					if( argument == "TRUE" )
						ctrlProc->setRunning(true);
					else
						ctrlProc->setRunning(false);

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "running" )


	if ( what == "returnval" )
	{
		if ( where == 0 )
		{
			//ignore error
		}
		else
		{

			depChilds.setCounter(where);

			switch( depChilds.childType() )
			{

				case 9: //vkProcCtrl
					/*emit ( parentCall( -1, "", "Error", 1,
						QString ("Property \"ReturnVal\"")
						+("is read-only.") ) );*/

					break;

				default:
					//Error
					break;

			} //switch

		} //else ( if (where==0) )

	} //if ( what == "returnval" )

} //doInstructions

void vkWidget::postOffice( int way, QString addressee,
	QString what, int how, QString argument ) //slot
{
int i, childId;
QString tmpString;

	if ( (way != -1) && (way != 0) && (way != myID) )
		return; //This is trash for me!

	debug ( "That's for me (way %d, I am %d)", way, myID);


	//On it's way from parent to parent ?
	if ( (way == 0) || (way == -1) )
	{//parent or error:

		emit( parentCall(way, addressee, what,
			how, argument ) );

		return;
	}



	//Am I the addressee ? (I or a dependent child)
	if ( myName == addressee )
	{// That's for me...

		doInstructions( what, how, argument, 0 );

		return;
	}
        else
        { //Maybe a dependent child...

		depChilds.resetCounter();

		do
		{
			if( depChilds.actualChildName() == addressee)
			{//Yes, it's a dependent child

				doInstructions( what, how, argument,
					depChilds.childId() );
				return;
			}

		} while ( depChilds.nextChildName() != "" );

        }


	//Try out whether this is _direct_ child:
	if ( addressee.find( '.', myName.length()+1 )
		!= -1 )
	{
	//Child is not directly addressee

		tmpString = addressee.left(
			addressee.find( '.',
			myName.length()+1 ) );
	}
	else
	{

		tmpString = addressee;

	}

	//is there a child 'adressee'; this MUST be an INdependent
	//child (vkWidget); (dependent childs --> above )

	for ( i = 1; i < 100; i++ )
	{

		if ( childNames[i] == tmpString )
		{
			childId = child_ids[i];
			break;
		}
	}

	if ( i < 99 ) //I know this child
	{
		emit ( childCall( childId, addressee, what,
			how, argument ) );
	}
	else
	{
		//No such widget!
		emit ( parentCall( -1, "", "Error", 1,
			QString ("Call for a widget, which is " )
			+("not registered in vkWidget object.") )
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;
	}

} //postOffice

void vkWidget::uncheckOpt() //SLOT
{
int i;

	depChilds.resetCounter();

	for ( i = 600; i < 700; i++ ) // optionButton range
	{
		depChilds.setCounter(i);

		if( depChilds.childType() == 6 && depChilds.getOptionButton() != 0L )
			depChilds.getOptionButton()->setChecked(false);

	}
}

//***********************End of class vkWidget **********************