/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <vkchildlist.h>
#include <vkchildlist.moc>

childList::childList()
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		button[i] = NULL;
		button_name[i] = "";

		label[i] = NULL;
		label_name[i] = "";

		pixlabel[i] = NULL;
		pixlabel_name[i] = "";

		lineedit[i] = NULL;
		lineedit_name[i] = "";

		listbox[i] = NULL;
		listbox_name[i] = "";

		checkbox[i] = NULL;
		checkbox_name[i] = "";

		optionbutton[i] = NULL;
		optionbutton_name[i] = "";

		slider[i] = NULL;
		slider_name[i] = "";

		procctrl[i] = NULL;
		procctrl_name[i] = "";
	}

	counter = 0;

} //constructor

bool childList::setNew ( vkPushButton *newWidget, const char *name )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( button_name[i] == "" )
			break;
	}


	if ( i == 99 )
	{ //No place for the new widget

		return( FALSE );
	}

	button[i] = newWidget;
	button_name[i] = name;

	counter = ( button_array * 100 ) + i;
		//Counter now points at new widget

	return( TRUE );

} //setNew ( vkPushButton *, ... )


bool childList::setNew ( vkLabel *newWidget, const char *name )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( label_name[i] == "" )
			break;
	}


	if ( i == 99 )
	{ //No place for the new widget

		return( FALSE );
	}

	label[i] = newWidget;
	label_name[i] = name;

	counter = ( label_array * 100 ) + i;
		//Counter now points at new widget

	return( TRUE );

} //setNew ( vkLabel *, ... )



bool childList::setNew ( vkPixLabel *newWidget, const char *name )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( pixlabel_name[i] == "" )
			break;
	}


	if ( i == 99 )
	{ //No place for the new widget

		return( FALSE );
	}

	pixlabel[i] = newWidget;
	pixlabel_name[i] = name;

	counter = ( pixlabel_array * 100 ) + i;
		//Counter now points at new widget

	return( TRUE );

} //setNew ( vkPixLabel *, ... )


bool childList::setNew ( vkLineEdit *newWidget, const char *name )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( lineedit_name[i] == "" )
			break;
	}

	if ( i == 99 )
	{ //No place for the new widget

		return( FALSE );
	}

	lineedit[i] = newWidget;
	lineedit_name[i] = name;


	counter = ( lineedit_array * 100 ) + i;
		//Counter now points at new widget

	return( TRUE );

} //setNew ( vkLineEdit *, ... )


bool childList::setNew ( vkListBox *newWidget, const char *name )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( listbox_name[i] == "" )
			break;
	}


	if ( i == 99 )
	{ //No place for the new widget

		return( FALSE );
	}

	listbox[i] = newWidget;
	listbox_name[i] = name;

	counter = ( listbox_array * 100 ) + i;
		//Counter now points at new widget

	return( TRUE );

} //setNew ( vkListBox *, ... )


bool childList::setNew ( vkCheckBox *newWidget, const char *name )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( checkbox_name[i] == "" )
			break;
	}


	if ( i == 99 )
	{ //No place for the new widget

		return( FALSE );
	}

	checkbox[i] = newWidget;

	checkbox_name[i] = name;

	counter = ( checkbox_array * 100 ) + i;
		//Counter now points at new widget

	return( TRUE );

} //setNew ( vkCheckBox *, ... )


bool childList::setNew ( vkOptionButton *newWidget, const char *name )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( optionbutton_name[i] == "" )
			break;
	}


	if ( i == 99 )
	{ //No place for the new widget

		return( FALSE );
	}

	optionbutton[i] = newWidget;
	optionbutton_name[i] = name;

	counter = ( optionbutton_array * 100 ) + i;
		//Counter now points at new widget

	return( TRUE );

} //setNew ( vkOptionButton *, ... )


bool childList::setNew ( vkSlider *newWidget, const char *name )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( slider_name[i] == "" )
			break;
	}


	if ( i == 99 )
	{ //No place for the new widget

		return( FALSE );
	}

	slider[i] = newWidget;
	slider_name[i] = name;

	counter = ( slider_array * 100 ) + i;
		//Counter now points at new widget

	return( TRUE );

} //setNew ( vkSlider *, ... )


bool childList::setNew ( vkProcCtrl *newWidget, const char *name )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( procctrl_name[i] == "" )
			break;
	}


	if ( i == 99 )
	{ //No place for the new widget

		return( FALSE );
	}

	procctrl[i] = newWidget;
	procctrl_name[i] = name;

	counter = ( procctrl_array * 100 ) + i;
		//Counter now points at new widget

	return( TRUE );

} //setNew ( vkProcCtrl *, ... )

void childList::setCounter( int newCounter )
{
	counter = newCounter-100;
}

void childList::resetCounter()
{
	setCounter(100);
}


QString childList::nextChildName()
{
int i = 0;

	counter++;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	if ( i == button_array )
	{
		while ( button_name[counter-(100*i)] == "" )
		{
			counter++; //Try next if empty

			if ( counter-(100*i) == 100 )
			{
				i++;
				break;
			}
		}

	} //if

	if ( i == label_array )
	{
		while ( label_name[counter-(100*i)] == "" )
		{
			counter++; //Try next if empty

			if ( counter-(100*i) == 100 )
			{
				i++;
				break;
			}
		}
	} //if

	if ( i == lineedit_array )
	{

		while ( lineedit_name[counter-(100*i)] == "" )
		{
			counter++; //Try next if empty

			if ( counter-(100*i) == 100 )
			{
				i++;
				break;
			}
		}
	} //if

	if ( i == listbox_array )
	{
		while ( listbox_name[counter-(100*i)] == "" )
		{
			counter++; //Try next if empty

			if ( counter-(100*i) == 100 )
			{
				i++;
				break;
			}
		}
	} //if


	if ( i == checkbox_array )
	{
		while ( checkbox_name[counter-(100*i)] == "" )
		{
			counter++; //Try next if empty

			if ( counter-(100*i) == 100 )
			{
				i++;
				break;
			}
		}
	} //if

	if ( i == optionbutton_array )
	{
		while ( optionbutton_name[counter-(100*i)] == "" )
		{
			counter++; //Try next if empty

			if ( counter-(100*i) == 100 )
			{
				i++;
				break;
			}
		}
	} //if

	if ( i == slider_array )
	{
		while ( slider_name[counter-(100*i)] == "" )
		{
			counter++; //Try next if empty

			if ( counter-(100*i) == 100 )
			{
				i++;
				break;
			}
		}
	} //if

	if ( i == pixlabel_array )
	{

		while ( pixlabel_name[counter-(100*i)] == "" )
		{
			counter++; //Try next if empty

			if ( counter-(100*i) == 100 )
			{
				i++;
				break;
			}
		}

	} //if

	if ( i == procctrl_array )
	{

		while ( procctrl_name[counter-(100*i)] == "" )
		{
			counter++; //Try next if empty

			if ( counter-(100*i) == 100 )
			{
				i++;
				break;
			}
		}
	} //if


	if ( i > procctrl_array ) //listbox_array is the _last_ array
	{
		return("");
	}

	return actualChildName();

} //nextChildName()


QString childList::actualChildName()
{
int i = 0;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	switch (i)
	{
		case button_array:
			return( button_name[counter-(i*100)] );
			break;

		case label_array:
			return( label_name[counter-(i*100)] );
			break;

		case lineedit_array:
			return( lineedit_name[counter-(i*100)] );
			break;

		case listbox_array:
			return( listbox_name[counter-(i*100)] );
			break;

		case checkbox_array:
			return( checkbox_name[counter-(i*100)] );
			break;

		case optionbutton_array:
			return( optionbutton_name[counter-(i*100)] );
			break;

		case slider_array:
			return( slider_name[counter-(i*100)] );
			break;

		case pixlabel_array:
			return( pixlabel_name[counter-(i*100)] );
			break;

		case procctrl_array:
			return( procctrl_name[counter-(i*100)] );
			break;

		default: //This should never happen...
			return("");
			break;
	} //switch

}


void childList::changeChildName( QString newName )
{
int i = 0;
debug( "\n\n%s\n", (const char *)newName );
	while ( counter - ( 100*i ) >= 100 )
		i++;

	switch (i)
	{
		case button_array:
			button_name[counter-(i*100)] = newName;
			break;

		case label_array:
			label_name[counter-(i*100)] = newName;
			break;

		case pixlabel_array:
			pixlabel_name[counter-(i*100)] = newName;
			break;

		case lineedit_array:
			lineedit_name[counter-(i*100)] = newName;
			break;

		case listbox_array:
			listbox_name[counter-(i*100)] = newName;
			break;

		case checkbox_array:
			checkbox_name[counter-(i*100)] = newName;
			break;

		case optionbutton_array:
			optionbutton_name[counter-(i*100)] = newName;
			break;

		case slider_array:
			slider_name[counter-(i*100)] = newName;
			break;

		case procctrl_array:
			procctrl_name[counter-(i*100)] = newName;
			break;

	} //switch

}


int childList::childType()
{
int i = 0;

	while ( counter - ( 100*i ) >=  100 )
		i++;

	debug ( "childList::childType(): ID from widget is %d.", i+1 );

	return(i+1);

}

int childList::childId()
{
	return (counter+100); //Must be >= 1
}

vkPushButton *childList::getButton()
{
int i = 0;
vkPushButton *ret;


	while ( counter - ( 100*i ) >= 100 )
		i++;

	ret = button[counter-(100*i)];

	return(ret);
}

vkLabel *childList::getLabel()
{
int i = 0;
vkLabel *ret;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	ret = label[counter-(100*i)];

	return(ret);

}

vkPixLabel *childList::getPLabel()
{
int i = 0;
vkPixLabel *ret;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	ret = pixlabel[counter-(100*i)];

	return(ret);

}

vkLineEdit *childList::getLineEdit()
{
int i = 0;
vkLineEdit *ret;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	ret = lineedit[counter-(100*i)];

	return(ret);

}

vkListBox *childList::getListBox()
{
int i = 0;
vkListBox *ret;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	ret = listbox[counter-(100*i)];

	return(ret);

}

vkCheckBox *childList::getCheckBox()
{
int i = 0;
vkCheckBox *ret;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	ret = checkbox[counter-(100*i)];

	return(ret);

}

vkOptionButton *childList::getOptionButton()
{
int i = 0;
vkOptionButton *ret;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	ret = optionbutton[counter-(100*i)];

	return(ret);

}

vkSlider *childList::getSlider()
{
int i = 0;
vkSlider *ret;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	ret = slider[counter-(100*i)];

	return(ret);

}

vkProcCtrl *childList::getProc()
{
int i = 0;
vkProcCtrl *ret;

	while ( counter - ( 100*i ) >= 100 )
		i++;

	ret = procctrl[counter-(100*i)];

	return(ret);

}

void childList::forgetChild()
{
	fatal ( "childList::forgetChild : not implemented, yet" );
}

int childList::maxIndex()
{
	return ( ( procctrl_array * 100 ) + 100 + 99 );
		//procctrl_array: Array with the highest value
		//+100: vkWidget has vk sub widgets in 1-99;
		//+99: Maximal index of array is 99
}
