/*
	resultview.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "resultview.h"
#include <strstream.h>
#include <qregexp.h>
#include <kfm.h>
#include <kfiledialog.h>
#include <kmsgbox.h>

#include "kdiskcat.h"

extern CategoryHandler* cathandler;
extern CatHandler* cat;
extern Kdiskcat* kdiskcat;
extern Prefs* prefs;

ResultView::ResultView(const char* title,const char* sep)
   :KTMainWindow("ResultsView")
{
	mounts.setAutoDelete(true);
   setCaption(title);
   view= new KTabListBox(this,"view",6);
   view->setSeparator(*sep);
   list_separator=*sep;
   view->setColumn(0,i18n("Filename"),100,KTabListBox::TextColumn,KTabListBox::ComplexOrder,KTabListBox::Descending,0);
   view->setColumn(1,i18n("Category"),100,KTabListBox::TextColumn,KTabListBox::ComplexOrder,KTabListBox::Descending,0);
   view->setColumn(2,i18n("Location"),150,KTabListBox::TextColumn,KTabListBox::ComplexOrder,KTabListBox::Descending,0);
   view->setColumn(3,i18n("Size"),70,KTabListBox::TextColumn,KTabListBox::ComplexOrder,KTabListBox::Descending,0);
   view->setColumn(4,i18n("Date"),106,KTabListBox::TextColumn,KTabListBox::ComplexOrder,KTabListBox::Descending,0);
   view->setColumn(5,i18n("Description"),100,KTabListBox::TextColumn,KTabListBox::ComplexOrder,KTabListBox::Descending,0);
   setView(view);
   initToolbar();
}

ResultView::~ResultView()
{
   view->clear();
   delete view;
   mounts.clear();
}

void ResultView::initToolbar()
{
  toolBar()->insertButton(Icon("goto.xpm"),TOOLBAR_GOTO,true,i18n("Go to (Open in the browse window)"));
  toolBar()->insertButton(Icon("openfolder.xpm"),TOOLBAR_OPEN,true,i18n("Open"));
  toolBar()->insertButton(Icon("save.xpm"),TOOLBAR_EXPORT,true,i18n("Export"));

  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("exit.xpm"),TOOLBAR_QUIT,true,i18n("Close"));

  connect(toolBar(), SIGNAL(clicked(int)), SLOT(slotToolbarClicked(int)));
}

void ResultView::slotToolbarClicked(int item)
{
   switch (item)
   {
      case TOOLBAR_OPEN:
         open();
         break;
      case TOOLBAR_GOTO:
      	gotoSelected();
         break;
      case TOOLBAR_QUIT:
         close();
         break;
      case TOOLBAR_EXPORT:
      	exportData();
      	break;
   }
}

void ResultView::exportData()
{
	QString filename,limiter;
	
	filename=KFileDialog::getSaveFileName("","*.txt",this,"export_fileselect");
	
	if (filename != 0)
	{
      QFile f(filename);

      if (f.open(IO_WriteOnly))
      {
		   KApplication::setOverrideCursor(waitCursor);
         QTextStream s(&f);

			if (prefs->export_delimiter=="\\t")
			{
				limiter="\t";
			}
			else
			{
				limiter=prefs->export_delimiter;
			}

         for (int i=0; i < (int)view->count(); i++)
         {
         	s << view->text(i,0);
         	s << limiter;
         	s << view->text(i,1);
         	s << limiter;
         	s << view->text(i,2);
         	s << limiter;
         	s << view->text(i,3);
         	s << limiter;
         	s << view->text(i,4);
         	s << limiter;         	
         	s << view->text(i,5);
         	if (i != (int) view->count() - 1)
         	{
	         	s << "\n";
	         }
         }

         f.close();
		   KApplication::restoreOverrideCursor();
      }
      else
      {
   		KMsgBox::message(this,i18n("Message"),i18n("Unable to write to the specified file!"),KMsgBox::STOP);
      }
	}
}

void ResultView::gotoSelected()
{
	KPath kp;
	QString str;
	
	if (view->count()!=0)
	{
		if (view->isMarked(view->currentItem()))
   	{
   		str=view->text(view->currentItem(),2);
   		kp=cat->Char2Path(&str);
   		kdiskcat->gotoSelected(view->text(view->currentItem(),1),kp,view->text(view->currentItem(),0));
   	}
  }
}

void ResultView::addResult(CatEntry* ce,KPath current_branch)
{
   QString str, tmp, val;
   QDate d;
   QTime t;

   str=ce->filename;
   str+=list_separator;
   str+=cathandler->getCurrentCategory();
   str+=list_separator;
   tmp=cat->Path2Char(current_branch);
   if (tmp.isEmpty())
   {
      tmp=" ";
   }
   str+=tmp;
   str+=list_separator;
   tmp.sprintf("%d",ce->f_size);
   str+=tmp;
   str+=list_separator;
   d=ce->mod_date.date();
   t=ce->mod_date.time();
   // QT v. 2 supports QString::arg, that's easier than the following:
   tmp=i18n("yyyy.mm.dd hh:MM");
   val.setNum(d.year())  ;tmp.replace("yyyy",val);
   val.setNum(d.month()) ;tmp.replace("mm"  ,("0"+val).right(2));
   val.setNum(d.day())   ;tmp.replace("dd"  ,("0"+val).right(2));
   val.setNum(t.hour())  ;tmp.replace("hh"  ,("0"+val).right(2));
   val.setNum(t.minute());tmp.replace("MM"  ,("0"+val).right(2));

   str+=tmp;
   str+=list_separator;
   str+=ce->description.simplifyWhiteSpace();

   view->appendItem((const char*) str);
}

void ResultView::addMount(QString pcategory,QString pcatalog,QString pmount_point)
{
	MountPointContainer* mp=new MountPointContainer();
	mp->category=pcategory;
	mp->catalog=pcatalog;
	mp->mount_point=pmount_point;
	mounts.append(mp);
}

void ResultView::open()
{
	MountPointContainer* mp;
	QString catalog_name;
	QString category_name;
	QString filename;
	KPath kp;
	QString str;
	QString url="file:";
	QString tmp;
	KFM *kfm;
	KPath location;
	bool found=false;
	
	if (view->count()!=0)
	{
   	if (view->isMarked(view->currentItem()))
   	{
   		filename=view->text(view->currentItem(),0);
   		category_name=view->text(view->currentItem(),1);
   		str=view->text(view->currentItem(),2);
   		kp=cat->Char2Path(&str);
   		location=kp;
   		while (kp.count()>1)
   		{
   		   kp.pop();
   		}
   		catalog_name=*kp.pop();
      	mp=mounts.first();
      	while (!found && mp!=0)
      	{
      	   if (mp->catalog==catalog_name && mp->category==category_name)
      	   {
      	      found=true;
      	   }
      	   else
      	   {
      	      mp=mounts.next();
      	   }
      	}
      	if (found)
      	{
         	str=filename;
         	tmp=mp->mount_point;
         	if (location.count() != 0)
         	{
      	   	location.push(&str);
      	   	if (tmp=="/") tmp="";
        			tmp+=cat->Path2Char(location,1);
        		}
      	
      		QFileInfo *fileInfo= new QFileInfo(tmp);
      		url+=tmp;
      		kfm=new KFM();
      		if (fileInfo->isDir())
      		{
      			kfm->openURL(url.data());
      		}
      		else
      		{
      			kfm->exec(url.data(),0L);
      		}
           	delete kfm;
      	}
   	}
	}
}