/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/
/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <qframe.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qgrpbox.h>

#include <kapp.h>
#include <kcolorbtn.h>


/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "config.h"
#include "kdiffColorDialog.h"
// #include "kdiffColorDialog.moc.cpp"


/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- GLOBAL VARIABLES
-----------------------------------------------------------------------------*/
kdiffColorDialog::kdiffColorDialog(QWidget * parent,
		 const QColor & insC,
		 const QColor & delC,
		 const QColor & chgC)
:QDialog(parent, "colorDialog", TRUE)
{

	QGroupBox *tmpQGroup;
	tmpQGroup = new QGroupBox(this, "Group_1");
	tmpQGroup->setMinimumSize(10, 10);
	tmpQGroup->setGeometry(10, 10, 310, 160);
	tmpQGroup->setFrameStyle(49);
	tmpQGroup->setTitle(i18n("background colors"));


	QLabel *tmpQLabel;
	tmpQLabel = new QLabel(this, "insertLineC");
	tmpQLabel->setGeometry(30, 30, 100, 30);
	tmpQLabel->setText(i18n("insert Line"));
	tmpQLabel->setAlignment(290);
	tmpQLabel->setMargin(-1);

	tmpQLabel = new QLabel(this, "deleteLine");
	tmpQLabel->setGeometry(30, 80, 100, 30);
	tmpQLabel->setText(i18n("delete Line"));
	tmpQLabel->setAlignment(290);
	tmpQLabel->setMargin(-1);

	tmpQLabel = new QLabel(this, "changeLine");
	tmpQLabel->setGeometry(30, 130, 100, 30);
	tmpQLabel->setText(i18n("change Line"));
	tmpQLabel->setAlignment(290);
	tmpQLabel->setMargin(-1);

	KColorButton *tmpQPushButton;
	tmpQPushButton = new KColorButton(this, "insertLineColorBtn");
	tmpQPushButton->setGeometry(150, 30, 100, 30);
	connect(tmpQPushButton, SIGNAL(changed(const QColor &)),
		this, SLOT(insertLineColorChanged(const QColor &)));
	tmpQPushButton->setText("");
	tmpQPushButton->setAutoRepeat(FALSE);
	tmpQPushButton->setAutoResize(FALSE);
	tmpQPushButton->setColor(insC);

	tmpQPushButton = new KColorButton(this, "deleteLineColorBtn");
	tmpQPushButton->setGeometry(150, 80, 100, 30);
	connect(tmpQPushButton, SIGNAL(changed(const QColor &)),
		this, SLOT(deleteLineColorChanged(const QColor &)));
	tmpQPushButton->setText("");
	tmpQPushButton->setAutoRepeat(FALSE);
	tmpQPushButton->setAutoResize(FALSE);
	tmpQPushButton->setColor(delC);

	tmpQPushButton = new KColorButton(this, "changeLineColorBtn");
	tmpQPushButton->setGeometry(150, 130, 100, 30);
	connect(tmpQPushButton, SIGNAL(changed(const QColor &)),
		this, SLOT(changeLineColorChanged(const QColor &)));
	tmpQPushButton->setText("");
	tmpQPushButton->setAutoRepeat(FALSE);
	tmpQPushButton->setAutoResize(FALSE);
	tmpQPushButton->setColor(chgC);


	QPushButton *tmpQPushB;
	tmpQPushB = new QPushButton(this, "okBtn");
	tmpQPushB->setGeometry(10, 180, 90, 30);
	connect(tmpQPushB, SIGNAL(clicked()), this, SLOT(okBtnClicked()));
	tmpQPushB->setText(i18n("OK"));
	tmpQPushB->setAutoRepeat(FALSE);
	tmpQPushB->setAutoResize(FALSE);
	tmpQPushB->setAutoDefault(TRUE);

	tmpQPushB = new QPushButton(this, "cancelBtn");
	tmpQPushB->setGeometry(120, 180, 90, 30);
	connect(tmpQPushB, SIGNAL(clicked()), this, SLOT(cancelBtnClicked()));
	tmpQPushB->setText(i18n("Cancel"));
	tmpQPushB->setAutoRepeat(FALSE);
	tmpQPushB->setAutoResize(FALSE);

	tmpQPushB = new QPushButton(this, "helpBtn");
	tmpQPushB->setGeometry(230, 180, 90, 30);
	connect(tmpQPushB, SIGNAL(clicked()), this, SLOT(helpBtnClicked()));
	tmpQPushB->setText(i18n("Help"));
	tmpQPushB->setAutoRepeat(FALSE);
	tmpQPushB->setAutoResize(FALSE);

	resize(330, 220);

	oldInsertColor = newInsertColor = insC;
	oldDeleteColor = newDeleteColor = delC;
	oldIChangeColor = newChangeColor = chgC;

	colorChanged = FALSE;

	setCaption(i18n("Setup Kdiff Colors"));
}


kdiffColorDialog::~kdiffColorDialog()
{
}

void kdiffColorDialog::insertLineColorChanged(const QColor & newC)
{
	newInsertColor = newC;
}

void kdiffColorDialog::deleteLineColorChanged(const QColor & newC)
{
	newDeleteColor = newC;
}

void kdiffColorDialog::changeLineColorChanged(const QColor & newC)
{
	newChangeColor = newC;
}


void kdiffColorDialog::okBtnClicked()
{
	done(1);
}

void kdiffColorDialog::cancelBtnClicked()
{
	done(0);
}

void kdiffColorDialog::helpBtnClicked()
{
	QString filename(APPNAME "/kdiff-4.html");

	// kapp is defined in kapp.h as #define kapp KApplication::getKApplication()
	kapp->invokeHTMLHelp(filename, "ss4.2");

}
