//
// Maker.h
//
// written by Michael Riedel <Michael.Riedel@gmx.de>
//
// KBuilder Maker Window Header

#ifndef	_Maker_H
#define	_Maker_H

#include <ktopwidget.h>
#include <kmenubar.h>
#include <kprocess.h>
#include <String.h>


/**
	The Maker class is used to control an external program
	as 'make' and its outputs. It also communicates with the 
	Editor class to display errors that occur during the 
	make process. 
*/
class Maker : public KTopLevelWidget
{
    Q_OBJECT
public:
    Maker(QWidget *parent = 0, const char *name = 0, 
    	  const char* path = ".", const char* command = "make");
    virtual ~Maker();

	bool saveMessagesTo(const QString& filename);
	
		/**
			Starts the currently set process (the filename
			of the executable is set via the command parameter
			of the constructor)
		*/
	void startMake();
	
		/**
			This kills a currently running command.
			
			@param  request If true, the user will be requested 
				    wether to kill the command or not. If false, 
				    no user input is requested and the command will
				    be killed.
			@return The return value is true, if the process was killed
					Otherwise, false is returned (there was no process
					running or the user selected not to kill the process).
		*/
	bool killMake(bool request = true);


protected:
	KProcess* 	Process;
   	QListBox* 	listbox;
	KMenuBar* 	mainMenu;
	QPopupMenu* file;
	QFont 	   	Font;
	int		 	idMake, idKill;
	static QList<Maker> Makers;
	QString		Path, Command;

	void resizeEvent(QResizeEvent* ev);
	void insertLBItem(const char* item);


public slots:
		// slots for window handling:
	void saveAsFileSlot();
	void closeWindowSlot();
	void selectFontSlot();
	void selectCommandSlot();
	void itemSelectedSlot(const char* item);

		// slots concerning the make process:
	void runMakeSlot();
	void killMakeSlot();
	void receiveStdOutSlot(KProcess* p, char* str, int num);
	void receiveStdErrSlot(KProcess* p, char* str, int num);
	void processExitedSlot(KProcess* p);
};

#endif // _Maker_H
