#ifndef SETUPDLG_H
#define SETUPDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif //HAVE_CONFIG_H

#include <kapp.h>
#include <qlined.h>
#include <qcombo.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qpixmap.h>
#include <kiconloaderdialog.h>
#include <qstrlist.h>
#include <ksimpleconfig.h>
#include <qmsgbox.h>
#include <ktabctl.h>
#include <qchkbox.h>
#include <qradiobt.h>
#include <qbttngrp.h>

class KBiffScramble
{
public:
	KBiffScramble(){}
	virtual ~KBiffScramble(){}

	const char* scramble(const char* text);
	const char* unscramble(const char* text);

private:
	const char* m_scramble(const char* text, bool state);
};

class KBiffMailboxInfo : public QWidget
{
	Q_OBJECT
public:
	KBiffMailboxInfo(QWidget *parent = 0);
	virtual ~KBiffMailboxInfo();
	
	const char* getMailbox();
	const bool  getReadLocalMailbox();
	const char* getPopServer();
	const char* getUser();
	const char* getPassword();
	const bool  getStorePassword();

public slots:
	void setMailbox(const char*);
	void setReadLocalMailbox(bool);
	void setPopServer(const char*);
	void setUser(const char*);
	void setPassword(const char*);
	void setStorePassword(bool);

protected slots:
	void m_browseLocalMailbox();
	void m_radioClicked(int);

private:
	QButtonGroup *m_buttonGroup;
	QLineEdit    *m_editMailbox;
	QLineEdit    *m_editPopServer;
	QLineEdit    *m_editUser;
	QLineEdit    *m_editPassword;
	QPushButton  *m_buttonLocalMailbox;
	QRadioButton *m_radioLocalMailbox;
	QRadioButton *m_radioRemoteMailbox;
	QCheckBox    *m_checkStorePassword;
};

class KBiffAbout : public QWidget
{
	Q_OBJECT
public:
	KBiffAbout(QWidget *parent=0);
	virtual ~KBiffAbout();
protected slots:
	void m_mailTo(const char*);
	void m_homepage(const char*);
};

class KBiffNewMailPrefs : public QWidget
{
	Q_OBJECT
public:
	KBiffNewMailPrefs(QWidget *parent=0);
	virtual ~KBiffNewMailPrefs();

	bool getRunCommand();
	const char* getRunCommandPath();
	bool getPlaySound();
	const char* getPlaySoundPath();
	bool getBeep();

public slots:
	void setRunCommand(bool);
	void setRunCommandPath(const char*);
	void setPlaySound(bool);
	void setPlaySoundPath(const char*);
	void setBeep(bool);
		
protected slots:
	void m_enableRunCommand(bool);
	void m_enablePlaySound(bool);
	void m_browseRunCommand();
	void m_browsePlaySound();

private:
	QLineEdit *m_editRunCommand;
	QLineEdit *m_editPlaySound;

	QCheckBox *m_checkRunCommand;
	QCheckBox *m_checkPlaySound;
	QCheckBox *m_checkBeep;

	QPushButton *m_buttonBrowsePlaySound;
	QPushButton *m_buttonBrowseRunCommand;
};

class KBiffGeneralPrefs : public QWidget
{
	Q_OBJECT
public:
	KBiffGeneralPrefs(QWidget *parent=0);
	virtual ~KBiffGeneralPrefs();

	const char* getButtonNewMail();
	const char* getButtonOldMail();
	const char* getButtonNoMail();
	const char* getCommand();
	const int   getPoll();
	const bool  getDock();
	const bool  getSessionManagement();

public slots:
	void setSessionManagement(bool);
	void setButtonNewMail(const char*);
	void setButtonNoMail(const char*);
	void setButtonOldMail(const char*);
	void setCommand(const char*);
	void setPoll(int);
	void setDock(bool);

private:
	QLineEdit* m_editPoll;
	QLineEdit* m_editCommand;
	QCheckBox* m_checkDock;
	QCheckBox* m_checkNoSession;

	KIconLoaderButton *m_buttonNoMail;
	KIconLoaderButton *m_buttonOldMail;
	KIconLoaderButton *m_buttonNewMail;
};

class KBiffSetupDlg : public QDialog
{
	Q_OBJECT
public:
	KBiffSetupDlg(const char *name = 0);
	~KBiffSetupDlg();

	void setName(const QString& name);

	const char* getNoMailPixmapPath();
	const char* getOldMailPixmapPath();
	const char* getNewMailPixmapPath();
	const char* getMailboxPath();
	const char* getCommand();
	const char* getName();
	const int   getPoll();
	const bool  getDock();
	const bool  getRunCommand();
	const char* getRunCommandPath();
	const bool  getPlaySound();
	const char* getPlaySoundPath();
	const bool  getBeep();
	const bool  getSessionManagement();
	const char* getPopServer();
	const char* getUser();
	const char* getPassword();
	const bool  getStorePassword();
	const bool  getReadLocalMailbox();
	const int   getPort();

	bool readMailboxConfig(const QString&);

public slots:
	void showHelp();

signals:
	void m_accept();
	void signal_setMailbox(const char*);
	void signal_setButtonNewMail(const char*);
	void signal_setButtonNoMail(const char*);
	void signal_setButtonOldMail(const char*);
	void signal_setCommand(const char*);
	void signal_setSessionManagement(bool);
	void signal_setPoll(int);
	void signal_setDock(bool);
	void signal_setRunCommand(bool);
	void signal_setRunCommandPath(const char*);
	void signal_setPlaySound(bool);
	void signal_setPlaySoundPath(const char*);
	void signal_setBeep(bool);
	void signal_setPopServer(const char*);
	void signal_setUser(const char*);
	void signal_setPassword(const char*);
	void signal_setReadLocalMailbox(bool);
	void signal_setStorePassword(bool);

protected slots:
	void m_slotDone();
	void m_mailboxWasSelected(int);
	void m_addNewMailbox();
	void m_deleteMailbox();
	void m_renameMailbox();
	void m_readConfig();

protected:
	void m_initDefaults();
	void m_setWidgets();
	void m_saveSettings();
	void m_checkForPort();

private:
	QStrList      m_mailboxList;
	QComboBox    *m_comboMailbox;
	QPushButton  *m_help;
	QPushButton  *m_ok;
	QPushButton  *m_cancel;

	KTabCtl           *m_tab;
	KBiffGeneralPrefs *m_generalPrefs;
	KBiffNewMailPrefs *m_newmailPrefs;
	KBiffMailboxInfo  *m_mailboxPrefs;
	KBiffAbout        *m_aboutPrefs;

	QString m_noMailPixmapPath;
	QString m_oldMailPixmapPath;
	QString m_newMailPixmapPath;
	QString m_mailboxPath;
	QString m_command;
	int     m_poll;
	QString m_name;
	bool    m_sessionManagement;
	bool    m_dock;
	bool    m_playSound;
	QString m_playSoundPath;
	bool    m_runCommand;
	QString m_runCommandPath;
	bool    m_beep;
	QString m_popServer;
	QString m_username;
	QString m_password;
	int     m_port;
	bool    m_readLocalMailbox;
	bool    m_storePassword;

	QString m_configFileName;

	KBiffScramble m_scramble;
};


class KBiffNewMailboxDlg : public QDialog
{
	Q_OBJECT
public:
	KBiffNewMailboxDlg(QWidget* parent = 0, const char* name = 0);
	~KBiffNewMailboxDlg();

	const char* getMailboxName()
		{ return m_editMailbox->text(); }

private:
	QLineEdit *m_editMailbox;
};

#endif // SETUPDLG_H
