#include"kbiff.h"
#include<kapp.h>
#include<kwm.h>

int main(int argc, char *argv[])
{
	KApplication app(argc, argv, "kbiff");
	KBiff kbiff;
	bool have_profile = false;

	app.setMainWidget(&kbiff);

	// parse the args to see if there is the -profile option
	if (argc == 3)
	{
		// check if this is the argument we are looking for
		if (QString(argv[1]) == "-profile")
			have_profile = true;
	}      

	// do we have the profile option?
	if (have_profile)
	{
		// yes, use the argv[2] as the profile name
		if (kbiff.readConfig(argv[2]) == false)
			return 0;
	}
	else
	{
		// started regular.  read in the config anyway
		if (kbiff.readConfig() == false)
			return 0;
	}

	// check if we are docked (only if restored)
	if (kbiff.isDocked())
	{
		kapp->setTopWidget(new QWidget);
		KWM::setDockWindow(kbiff.winId());
	}
	else
		kapp->setTopWidget(&kbiff);

	// enable session management
	kapp->enableSessionManagement();

	kbiff.show();

	return app.exec();
}
