/*
 * KBatMon - Copyright 1999 Russ Steffen <rsteffen@ia.net>
 *
 * Released under the terms of the GNU General Public License
 *
 *
 * $Id: apmInterface.h,v 1.7 1999/01/15 06:08:47 russ Exp $
 *
 * $Log: apmInterface.h,v $
 * Revision 1.7  1999/01/15 06:08:47  russ
 * Added file headers.
 *
 *
 */
 
#ifndef _APMINTERFACE_H_
#define _APMINTERFACE_H_

#include <config.h>
#include <qobject.h>
#include <qdatetime.h>
#include <qtimer.h>
#include <qsocketnotifier.h>
#include <kprocess.h>

extern "C" {  // GRRR
#include <apm.h>
}

class APMInterface : public QObject
{
    Q_OBJECT

public :
    APMInterface();
    virtual ~APMInterface();

    bool haveAPMBIOS(void);
    bool haveAPMDevAccess( void );

    QString getAPMDriverVersion(void);
    QString getAPMBIOSVersion(void);

    bool getACLineStatus(void);
    bool haveBattery(void);
    QString getBatteryStatusString(void);
    QString getPowerStatusString(void);

    int getBatteryPercentage(void);
    int getBatteryTime(void);

    // Low level flags
    int getAPMFlags(void);
    int getBatteryFlags(void);
    int getBatteryStatus(void);

public slots:
    void suspend();
    void standby();
    
signals :
    void update();

    
private slots:
    void apmEvent();
    void timerEvent();

private:
    bool haveAPM;
    bool haveDevAccess;
    
    QTimer *timer;
    QSocketNotifier *apm_dev;
    int apm_dev_fd;
    struct apm_info status;
};

#endif /* _APMINTERFACE_H_ */
