/***************************************************************************
                          processus.cpp  -  description
                             -------------------
    begin                : Sat Jun 5 1999
    copyright            : a little improvement of kprocess.cpp (C) Christian Czezatke by Eric Coquelle
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "processus.h"
#include <kprocess.h>
#define _MAY_INCLUDE_KPROCESSCONTROLLER_
#include "kprocctrl.h"

#include <qapplication.h>

#include <config.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>

/////////////////////////////
// public member functions //
/////////////////////////////

bool CProcessus::demarrer(FILE** flot, Communication comm, RunMode runmode)
{
   if(runmode!=DontCare)
   	return start(runmode,comm);
   	
   uint i;
   uint n = arguments.count();
   char **arglist;
 
   if (runs || (0 == n)) {//if (isRunning()) {
     return FALSE;  // cannot start a process that is already running
     // or if no executable has been assigned
   }

   status = 0;
 
   arglist = (char **)malloc( (n+1)*sizeof(char *));
   CHECK_PTR(arglist);
   for (i=0; i < n; i++)
     arglist[i] = arguments.at(i);
   arglist[n]= 0;//NULL;
 
   if (!setupCommunication(comm))
     debug("Could not setup Communication!");
 
   runs = TRUE;
   pid = fork();
 
   if (0 == pid) {
     // The child process

     if(!commSetupDoneC())
	 		debug("Could not finish comm setup in child!");

     setpgid(0,0);
        // restore default SIGPIPE handler (restore)
        struct sigaction act;
        sigemptyset(&(act.sa_mask));
        sigaddset(&(act.sa_mask), SIGPIPE);
        act.sa_handler = SIG_DFL;
        act.sa_flags = 0;
        sigaction(SIGPIPE, &act, 0L);

     execvp(arglist[0], arglist);
     exit(-1);
 
   } else if (-1 == pid) {
     // forking failed
 
     runs = FALSE;
     free(arglist);
     return FALSE;
 
   } else {
     // the parent continues here

		if (communication & Stdin)
	  	close(in[0]);
		if (communication & Stdout)
		  close(out[1]);
		if (communication & Stderr)
		  close(err[1]);		

     if (comm == Stdin)
	     *flot = fdopen(in[1], "w");
     else if (comm == Stdout)
	     *flot = fdopen(out[0], "r");
     else if (comm == Stderr)
	     *flot = fdopen(err[0], "r");

   }
   free(arglist);    
   return TRUE;
 }
