/***************************************************************************
                  optionsdialog.h  -  Options Dialog
                  ----------------------------------
    begin                : 08/01/99
    copyright            : (C) 1999 by Ryan Cumming
    email                : bodnar42@bodnar42.dhs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

#include <qtabdialog.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <kiconloaderdialog.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>

#include <kapp.h>


/**
  *@author Ryan Cumming
  */

struct iconData {
	bool valid;

	QString filename;
	QString fullname;

	bool isMovie;
	bool drawBar;

	unsigned int top;
	unsigned int bottom;
	unsigned char percentSize;
};

struct configData {
	bool apmdRunning;
	unsigned int updateInterval;
	
	bool lowNotification;
	unsigned int lowThresholdPercent;
	bool fullNotification;
	unsigned int fullThresholdPercent;

	struct iconData icons[5];
};

class optionsDialog : public QTabDialog  {
  Q_OBJECT
public:
	optionsDialog();
	~optionsDialog();

	configData *config;

private:
	QCheckBox *apmdRunning;
	QSpinBox *updateInterval;
	QLabel *updateIntervalLabel;

	QCheckBox *lowNotification;
	QSpinBox *lowThresholdPercent;
	QLabel *lowThresholdPercentLabel;
	QCheckBox *fullNotification;
	QSpinBox *fullThresholdPercent;
  QLabel *fullThresholdPercentLabel;

	KIconLoaderButton *buttonCritical;
	KIconLoaderButton *buttonLow;
	KIconLoaderButton *buttonHigh;
	KIconLoaderButton *buttonCharging;
	KIconLoaderButton *buttonUnknown;

private slots:
	void somethingChecked();
	void loadConfig();
	void saveConfig();
};

#endif































