/***************************************************************************
                  		kapm.h - KAPM Main File
                  		-----------------------
    begin                : ??/??/99
    copyright            : (C) 1999 by Ryan Cumming
    email                : bodnar42@bodnar42.dhs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KAPM_H
#define KAPM_H

#include <kapp.h>
#include <qlabel.h>
#include <kwm.h>
#include <kiconloader.h>
#include <qpopupmenu.h>
#include <errno.h>
#include <time.h>
#include <qtooltip.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qimage.h>

#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "optionsdialog.h"
#include "apm.h"


class Kapm : public QLabel {
  Q_OBJECT 
public:
  /** construtor */
  Kapm();
  /** destructor */
  ~Kapm();

	KConfig *configFile;

private:
	QPopupMenu *menu;
  configData config;

	void mousePressEvent(QMouseEvent *e);
	void changeState( int state );
	void checkApm();
	void errorMsg(const char *message);
	void drawIcon(bool forceUpdate);
	void timerEvent ( QTimerEvent *e );
	QString* statusString();
	void loadConfig();
	void saveConfig();
	bool isGIF8x(const char* file_name); // From KBiff

	bool supressFullNotification;
	bool supressLowNotification;

	void fillBar(QImage image);
	void scanIcon(char index);

private slots:
	void slotSuspend();
	void slotStandby();
	void slotOptions();
	void slotAPMStatus();
	void slotAbout();
	void slotHelp();
	void slotPowerOff();
	void slotQuit();
	
};
#endif
























































