/* apm.cpp - KAPM's APM Driver (kapmlib), version 0.2.3
   Based on apmlib, but there are important differences:
	 1) All functions KAPM doesn't use have been removed
	 2) Support for pre-1.x versions of the kernel APM driver has been removed
   3) Sanity checks are only done once, if apmCheck() returns a non-zero
	    value, you MUST NOT use any other kapmlib functions
   4) There is one gloabl APM info struct, it is no longer passed round
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include "apm.h"

apm_info i;

/* Wrapper around apmRead that makes it behave exactly like apm_read did
 * in pre-0.2.3 versions of kapmlib. This is to prevent cycles being wasted
 * on redundant sanity checks everytime the APM info was being read */
int apmCheck() {
	FILE *str;

	if (!(str = fopen( APM_PROC, "r" ))) return 1;
	fclose( str );

	apmRead();
	if (i.driver_version[0] == 'B')  // old style.  argh.
		return 2;

	return 0;
}

// Read information from /proc/apm
void apmRead()
{
	FILE *str;
	char units[10];
	char buffer[64];

	str = fopen( APM_PROC, "r" );
	fgets( buffer, sizeof( buffer ) - 1, str );
	buffer[ sizeof( buffer ) - 1 ] = '\0';
	sscanf( buffer, "%s %d.%d %x %x %x %x %d%% %d %s\n",
	   (char *)i.driver_version,
	   &i.apm_version_major,
	   &i.apm_version_minor,
	   &i.apm_flags,
	   &i.ac_line_status,
	   (unsigned int*)(&i.battery_status),
	   &i.battery_flags,
	   (int*)(&i.battery_percentage),
	   &i.battery_time,
	   units );
	i.using_minutes = (strncmp( units, "min", 3 ) == 0);

	fclose( str );
	return;
}


/* Lookup the device number for the apm_bios device. */

dev_t apmDev( void )
{
   static int cached = -1;

   if (cached >= 0) return cached;

   return cached = makedev( 10, 134 );
}


/* Return a file descriptor for the apm_bios device, or -1 if there is an
   error.  Is this method secure?  Should we make the device in /dev
   instead of /tmp? */

int apmOpen( void )
{
   int      fd;

   if (access( APM_PROC, R_OK )) return -1;
   fd = open( APM_DEVICE, O_RDWR );
   
   return fd;
}






























