// KAM Configuration Dialog

const int bwidth  = 50;
const int bheight = 24;
const int dwidth  = 330;
const int dheight = 150;

#include <stdlib.h>

#include <qpushbt.h>
#include <qlabel.h>


#include <kconfig.h>

#include "config.H"



TConfig::TConfig( QWidget *parent, const char *name, TConfigData *conf )
  : QDialog( parent, name, TRUE ) {        

    setMinimumSize( dwidth, dheight );
    setMaximumSize( dwidth, dheight );


    ConfData = conf;


    // label for incoming path
    QLabel *indirL = new QLabel( "Incoming Directory", this );
    indirL->setGeometry( 10, 10, 
			 ( indirL->sizeHint().isValid() ?
			   indirL->sizeHint().width() : 100 ), 
			 bheight );
    
    // line edit field for incoming path
    IndirE = new QLineEdit( this );
    IndirE->setText( ConfData->IndirPath.data() );
    IndirE->setGeometry( indirL->x() + indirL->width() + 10, 
			 indirL->y(), 
			 dwidth - ( indirL->x() + indirL->width() ) - 20, 
			 bheight );

    // label for update interval
    QLabel *updateL = new QLabel( "Update Interval", this );
    updateL->setGeometry( 10, 
			  indirL->y() + indirL->height() + 10, 
			  indirL->width(),
			  bheight );

    // line edit field for update interval
    UpdateE = new QLineEdit( this );
    QString upstr;
    upstr.sprintf( "%i", ConfData->UpdateInterval );
    UpdateE->setText( upstr.data() );
    UpdateE->setGeometry( updateL->x() + updateL->width() + 10,
			  updateL->y(), 
			  35, 
			  bheight );
    QLabel *secondsL = new QLabel( "Seconds", this );
    secondsL->setGeometry( UpdateE->x() + UpdateE->width() + 5, 
			   updateL->y(), 
			   ( secondsL->sizeHint().isValid() ?
			     secondsL->sizeHint().width() : 50 ),
			   bheight );
      

    // vbox version radio buttons
    QLabel *versionL = new QLabel( "Vbox Version", this );
    versionL->setGeometry( updateL->x(),
			   updateL->y() + updateL->height() +10,
			   indirL->width(),
			   bheight );
    QButtonGroup *bg = new QButtonGroup( this );
    bg->hide();
    V1 = new QRadioButton( "Version 1", this );
    V2 = new QRadioButton( "Version 2", this );
    bg->insert( V1 );
    bg->insert( V2 );
    V1->setGeometry( versionL->x() + versionL->width() + 10,
		     versionL->y(), 
		     V1->sizeHint().width(), 
		     bheight );
    V2->setGeometry( V1->x() + V1->width() +10,
		     V1->y(),
		     V2->sizeHint().width(), 
		     bheight );
    if ( ConfData->VboxVersion == 1 ) V1->setChecked( true );
    if ( ConfData->VboxVersion == 2 ) V2->setChecked( true );


    // cancel button
    QPushButton *cancel = new QPushButton( "Cancel", this );        
    cancel->setGeometry( dwidth - bwidth - 10,
			 dheight - bheight - 10,
			 bwidth, bheight );
    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );


    // OK button
    QPushButton *ok = new QPushButton( "Ok", this );        
    ok->setGeometry( cancel->x() - bwidth - 10,
		     cancel->y(),
		     bwidth, bheight );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );

}


void TConfig::accept() {

  ConfData->IndirPath = IndirE->text();
  ConfData->UpdateInterval = atoi( UpdateE->text() );
  if ( V1->isChecked() )
    ConfData->VboxVersion = 1;
  if ( V2->isChecked() )
    ConfData->VboxVersion = 2;

  emit configChanged( ConfData );

  QDialog::accept();

}

#include "config.moc"


