#include <qaccel.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <kmsgbox.h>
#include <ktopwidget.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <qlistbox.h>
#include <fstream.h>
#include <qtooltip.h>
#include <locale.h>
#include "kBeroFTPD.moc"

#define	VERSION	"1.0.0"

void kBeroFTPD::init()
{
	ftpxs=new ftpaccess("/etc/ftpaccess");
	setFixedSize(640,380);
	resize(640,380);

	// initialization stuff
	KWM::setIcon(winId(), kapp->getIcon());
	KWM::setMiniIcon(winId(), kapp->getMiniIcon());

	// Menu
	// File
	file = new QPopupMenu;
	file->insertItem(i18n("&Load /etc/ftpaccess"), ID_FILE_LOADFTPACCESS);
	file->insertItem(i18n("Load &other file"), ID_FILE_LOADOTHER);
	file->insertSeparator();
	file->insertItem(i18n("&Save /etc/ftpaccess"), ID_FILE_SAVEFTPACCESS);
	file->insertItem(i18n("Save o&ther file"), ID_FILE_SAVEOTHER);
	file->insertSeparator();
	file->insertItem(i18n("&Quit"), ID_FILE_QUIT);
	connect(file, SIGNAL(activated (int)), SLOT(handleMenu(int)));

	// Help
	help=kapp->getHelpMenu(true,"kBeroFTPD - the KDE BeroFTPD configurator\n(c) 1998 by Bernhard Rosenkrnzer <bero@beroftpd.unix.eu.org>.");

	menu=new KMenuBar(this);
	CHECK_PTR( menu );
	menu->insertItem( i18n("&File"), file );
	menu->insertSeparator();
	menu->insertItem( i18n("&Help"), help );
	menu->show();

	// tab dialog...
	ktc=new KTabCtl(this,"kBeroFTPD");

	// tab #1: User classes
	ClassesTab=new UserClasses(ktc, "User Classes");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), ClassesTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), ClassesTab, SLOT(update()));

	// tab #2: Directories
	DirectoriesTab=new Directories(ktc, "Directories");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), DirectoriesTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), DirectoriesTab, SLOT(update()));

	// tab #3: Security
	SecurityTab=new Security(ktc, "Security");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), SecurityTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), SecurityTab, SLOT(update()));

	// tab #4: User Information
	MessagesTab=new Messages(ktc, "Messages");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), MessagesTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), MessagesTab, SLOT(update()));

	// tab #5: Logging
	LoggingTab=new Logging(ktc, "Logging");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), LoggingTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), LoggingTab, SLOT(update()));

	// tab #6: Ratios
	RatiosTab=new Ratios(ktc, "Ratios");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), RatiosTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), RatiosTab, SLOT(update()));

	// tab #7: Uploads
	UploadsTab=new Uploads(ktc, "Uploads");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), UploadsTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), UploadsTab, SLOT(update()));

	// show tabs...
	ktc->move(0,menu->height());
	ktc->resize(640,380-menu->height());
	
	ktc->addTab(ClassesTab, i18n("User &Classes"));
	ktc->addTab(DirectoriesTab, i18n("&Directories"));
	ktc->addTab(SecurityTab, i18n("&Security"));
	ktc->addTab(MessagesTab, i18n("&Messages"));
	ktc->addTab(LoggingTab, i18n("&Logging"));
	ktc->addTab(RatiosTab, i18n("Rat&ios"));
	ktc->addTab(UploadsTab, i18n("&Uploads"));

	// Set some default values...
	emit ftpaccessLoaded(ftpxs);

	ktc->show();

	show();
}
void kBeroFTPD::handleMenu(int item)
{
	switch(item) {
	case ID_FILE_LOADFTPACCESS:
	case ID_FILE_LOADOTHER:
		{
			char *fileName;
			if(item==ID_FILE_LOADOTHER) {
				KFileDialog *load;
				load=new KFileDialog(".","*",this,i18n("Select ftpaccess file"),true,false);
				fileName=strdup(load->getOpenFileName());
				delete load;
			} else
				fileName=strdup("/etc/ftpaccess");
			ftpxs->read(fileName);
			emit ftpaccessLoaded(ftpxs);
			free(fileName);
			break;
		}
	case ID_FILE_SAVEFTPACCESS:
	case ID_FILE_SAVEOTHER:
		{
			char *fileName;
			if(item==ID_FILE_SAVEOTHER) {
				KFileDialog *save;
				save=new KFileDialog(".","*",this,"Select ftpaccess file",true,false);
				fileName=strdup(save->getSaveFileName());
				delete save;
			} else
				fileName=strdup("/etc/ftpaccess");
			emit aboutToSave();
			if(!ftpxs->write(fileName))
				KMsgBox::message(this, i18n("Error"), i18n("An error occured while trying to save."), KMsgBox::INFORMATION, i18n("&Close"));
			free(fileName);
			break;
		}
	case ID_FILE_QUIT:
		kapp->quit();
		break;
	}
}
kBeroFTPD::kBeroFTPD()
{
	init();
	setCaption(kapp->getCaption());
}
kBeroFTPD::~kBeroFTPD()
{
	if(ftpxs!=0)
		delete ftpxs;
}
void kBeroFTPD::closeEvent(QCloseEvent *e)
{
	kapp->quit();
	e->accept();
}
int main(int argc, char **argv)
{
	setlocale(LC_CTYPE, "");

	KApplication app(argc, argv, "kBeroFTPD");
	kBeroFTPD *a=new kBeroFTPD;
	a->setCaption("kBeroFTPD 1.0.0");
	app.setMainWidget(a);
	return app.exec();
}
