#include "Security.moc"
#include "AddNoRet.h"
#include <kapp.h>
#include <klocale.h>
#include <qlistbox.h>
#include <qtooltip.h>
#include <qbuttongroup.h>

Security::Security (QWidget * parent = 0, const char *name = 0):QWidget (parent, name)
{
  int x = 5, y = 0;
  int w = 640, h = 380;		// see UserClasses constructor in UserClasses.cpp

  ftpxs = 0;
  QLabel *lbl1 = new QLabel (i18n ("&Noretrieves:"), this);
  lbl1->move (x, 0);
  y += lbl1->height ();
  QToolTip::add (lbl1, i18n ("Files and Directories that can't be retrieved"));
  addNoRet = new QPushButton (i18n ("&Add"), this);
  delNoRet = new QPushButton (i18n ("&Remove"), this);
  noretrieves = new QListBox (this);
  lbl1->setBuddy (noretrieves);
  noretrieves->setGeometry (x, y, 120, h - y - 2 * height () - 10 - addNoRet->height () - delNoRet->height ());
  noretrieves->setAutoUpdate (true);
  noretrieves->setAutoScroll (true);
  QToolTip::add (noretrieves, i18n ("Files and Directories that can't be retrieved"));
  y += noretrieves->height () + 5;
  addNoRet->setGeometry (x, y, 120, addNoRet->height ());
  delNoRet->setGeometry (x, addNoRet->y () + addNoRet->height (), 120, delNoRet->height ());
  connect (addNoRet, SIGNAL (clicked ()), SLOT (addNoRetPressed ()));
  connect (delNoRet, SIGNAL (clicked ()), SLOT (delNoRetPressed ()));
  QLabel *lbl2 = new QLabel (i18n ("Number of allo&wed failed logins:"), this);
  lbl2->resize (lbl2->sizeHint ());
  loginfails = new QSpinBox (this);
  loginfails->resize (loginfails->sizeHint ());
  lbl2->setBuddy (loginfails);
  if (ftpxs != 0)
    loginfails->setValue (ftpxs->getLoginFails ());
  x += noretrieves->width () + 5;
  y = 5;
  lbl2->move (x, y);
  y += loginfails->height ();
  loginfails->move (x + lbl2->width (), 5);
  priv = new QCheckBox (i18n ("Permit SITE &GROUP"), this);
  priv->resize (priv->sizeHint ());
  if (ftpxs != 0)
    priv->setChecked (ftpxs->getPrivate ());
  priv->move (x, y);
  y += priv->height ();
  QLabel *lbl3 = new QLabel (i18n ("Permit the following commands to users:"), this);
  lbl3->setGeometry (x, y, lbl3->sizeHint ().width (), lbl3->height ());
  y += lbl3->height ();

  int tY = y, Lw = (w - x - 10) / 4;
  QLabel *lbl4 = new QLabel (i18n ("Anonymous"), this);
  lbl4->setAlignment (AlignCenter);
  lbl4->setGeometry (x + Lw, y, Lw, lbl4->height ());
  QLabel *lbl5 = new QLabel (i18n ("Guest"), this);
  lbl5->setAlignment (AlignCenter);
  lbl5->setGeometry (x + 2 * Lw, y, Lw, lbl5->height ());
  QLabel *lbl6 = new QLabel (i18n ("Real"), this);
  lbl6->setAlignment (AlignCenter);
  lbl6->setGeometry (x + 3 * Lw, y, Lw, lbl6->height ());
  y += lbl6->height ();
  QLabel *lbl7 = new QLabel ("chmod", this);
  lbl7->setGeometry (x + 5, y, Lw, lbl7->height ());
  chmodAnon = new QCheckBox (this);
  chmodAnon->resize (chmodAnon->sizeHint ().width (), lbl7->height ());
  chmodAnon->move (x + Lw + Lw / 2, y);
  chmodGuest = new QCheckBox (this);
  chmodGuest->resize (chmodGuest->sizeHint ().width (), lbl7->height ());
  chmodGuest->move (x + 2 * Lw + Lw / 2, y);
  chmodReal = new QCheckBox (this);
  chmodReal->resize (chmodGuest->sizeHint ().width (), lbl7->height ());
  chmodReal->move (x + 3 * Lw + Lw / 2, y);
  y += lbl7->height ();
  QLabel *lbl8 = new QLabel ("delete", this);
  lbl8->setGeometry (x + 5, y, Lw, lbl8->height ());
  deleteAnon = new QCheckBox (this);
  deleteAnon->resize (deleteAnon->sizeHint ().width (), lbl8->height ());
  deleteAnon->move (x + Lw + Lw / 2, y);
  deleteGuest = new QCheckBox (this);
  deleteGuest->resize (deleteGuest->sizeHint ().width (), lbl8->height ());
  deleteGuest->move (x + 2 * Lw + Lw / 2, y);
  deleteReal = new QCheckBox (this);
  deleteReal->resize (deleteGuest->sizeHint ().width (), lbl8->height ());
  deleteReal->move (x + 3 * Lw + Lw / 2, y);
  y += lbl8->height ();
  QLabel *lbl9 = new QLabel ("overwrite", this);
  lbl9->setGeometry (x + 5, y, Lw, lbl9->height ());
  overwriteAnon = new QCheckBox (this);
  overwriteAnon->resize (overwriteAnon->sizeHint ().width (), lbl9->height ());
  overwriteAnon->move (x + Lw + Lw / 2, y);
  overwriteGuest = new QCheckBox (this);
  overwriteGuest->resize (overwriteGuest->sizeHint ().width (), lbl9->height ());
  overwriteGuest->move (x + 2 * Lw + Lw / 2, y);
  overwriteReal = new QCheckBox (this);
  overwriteReal->resize (overwriteGuest->sizeHint ().width (), lbl9->height ());
  overwriteReal->move (x + 3 * Lw + Lw / 2, y);
  y += lbl9->height ();
  QLabel *lbl10 = new QLabel ("rename", this);
  lbl10->setGeometry (x + 5, y, Lw, lbl10->height ());
  renameAnon = new QCheckBox (this);
  renameAnon->resize (renameAnon->sizeHint ().width (), lbl10->height ());
  renameAnon->move (x + Lw + Lw / 2, y);
  renameGuest = new QCheckBox (this);
  renameGuest->resize (renameGuest->sizeHint ().width (), lbl10->height ());
  renameGuest->move (x + 2 * Lw + Lw / 2, y);
  renameReal = new QCheckBox (this);
  renameReal->resize (renameGuest->sizeHint ().width (), lbl10->height ());
  renameReal->move (x + 3 * Lw + Lw / 2, y);
  y += lbl10->height ();
  QLabel *lbl11 = new QLabel ("umask", this);
  lbl11->setGeometry (x + 5, y, Lw, lbl11->height ());
  umaskAnon = new QCheckBox (this);
  umaskAnon->resize (umaskAnon->sizeHint ().width (), lbl11->height ());
  umaskAnon->move (x + Lw + Lw / 2, y);
  umaskGuest = new QCheckBox (this);
  umaskGuest->resize (umaskGuest->sizeHint ().width (), lbl11->height ());
  umaskGuest->move (x + 2 * Lw + Lw / 2, y);
  umaskReal = new QCheckBox (this);
  umaskReal->resize (umaskGuest->sizeHint ().width (), lbl11->height ());
  umaskReal->move (x + 3 * Lw + Lw / 2, y);
  y += lbl11->height ();
  for (int i = 0; i < 5; i++)
    {				// draw table frames

      QFrame *Frame = new QFrame (this);
      Frame->setFrameStyle (QFrame::VLine | QFrame::Sunken);
      Frame->setGeometry (x + i * Lw, tY, 2, y - tY);
    }
  for (int i = 0; i < 7; i++)
    {
      QFrame *Frame = new QFrame (this);
      Frame->setFrameStyle (QFrame::HLine | QFrame::Sunken);
      Frame->setGeometry (x, tY + i * lbl7->height (), 4 * Lw, 2);
    }
  y += 10;
  QLabel *lbl12 = new QLabel (i18n ("Check password for anonymous:"), this);
  lbl12->move (x, y);
  lbl12->resize (lbl12->sizeHint ());
  QButtonGroup *pwc = new QButtonGroup ();
  PasswdNone = new QRadioButton (i18n ("&No"), this);
  QToolTip::add (PasswdNone, i18n ("Don't check password given for anonymous/ftp at all"));
  PasswdNone->move (x + lbl12->width () + 5, y);
  PasswdNone->resize (PasswdNone->sizeHint ());
  pwc->insert (PasswdNone);
  PasswdTrivial = new QRadioButton (i18n ("&trivial"), this);
  QToolTip::add (PasswdTrivial, i18n ("Password for anonymous/ftp must contain an @ character"));
  PasswdTrivial->move (PasswdNone->x () + PasswdNone->width () + 5, y);
  PasswdTrivial->resize (PasswdTrivial->sizeHint ());
  pwc->insert (PasswdTrivial);
  PasswdRFC = new QRadioButton (i18n ("&RFC822"), this);
  QToolTip::add (PasswdRFC, i18n ("Make sure password for anonymous/ftp is a valid e-mail address\naccording to RFC822"));
  PasswdRFC->move (PasswdTrivial->x () + PasswdTrivial->width () + 5, y);
  PasswdRFC->resize (PasswdRFC->sizeHint ());
  pwc->insert (PasswdRFC);
  PasswdEnforce = new QCheckBox (i18n ("Enf&orce"), this);
  QToolTip::add (PasswdEnforce, i18n ("If this is checked, people using something other than an e-mail address\nas anonymous password will not be allowed to log in.\n\nIf this is not checked, they will just be warned and told to use their\ne-mail address as password next time."));
  PasswdEnforce->move (PasswdRFC->x () + PasswdRFC->width () + 10, y);
  PasswdEnforce->resize (PasswdEnforce->sizeHint ());
}
Security::~Security ()
{
}
void Security::ftpaccessLoaded (ftpaccess * xs)
{
  ftpxs = xs;
  loginfails->setValue (ftpxs->getLoginFails ());
  priv->setChecked (ftpxs->getPrivate ());
  chmodAnon->setChecked (ftpxs->getChmod () & ANONYMOUS);
  chmodGuest->setChecked (ftpxs->getChmod () & GUEST);
  chmodReal->setChecked (ftpxs->getChmod () & REAL);
  deleteAnon->setChecked (ftpxs->getDelete () & ANONYMOUS);
  deleteGuest->setChecked (ftpxs->getDelete () & GUEST);
  deleteReal->setChecked (ftpxs->getDelete () & REAL);
  overwriteAnon->setChecked (ftpxs->getOverwrite () & ANONYMOUS);
  overwriteGuest->setChecked (ftpxs->getOverwrite () & GUEST);
  overwriteReal->setChecked (ftpxs->getOverwrite () & REAL);
  renameAnon->setChecked (ftpxs->getRename () & ANONYMOUS);
  renameGuest->setChecked (ftpxs->getRename () & GUEST);
  renameReal->setChecked (ftpxs->getRename () & REAL);
  umaskAnon->setChecked (ftpxs->getUmask () & ANONYMOUS);
  umaskGuest->setChecked (ftpxs->getUmask () & GUEST);
  umaskReal->setChecked (ftpxs->getUmask () & REAL);
  if (ftpxs->getPwCheck () & TRIVIAL)
    PasswdTrivial->setChecked (true);
  else if (ftpxs->getPwCheck () & RFC822)
    PasswdRFC->setChecked (true);
  else
    PasswdNone->setChecked (true);
  PasswdEnforce->setChecked ((ftpxs->getPwCheck () & ((int) ENFORCE)) != 0);
  redrawNoRetrieves ();
}
void Security::update ()
{
  ftpxs->setLoginFails (loginfails->value ());
  ftpxs->setPrivate (priv->isChecked ());
  unsigned short tmp = 0;
  if (chmodAnon->isChecked ())
    tmp |= ANONYMOUS;
  if (chmodGuest->isChecked ())
    tmp |= GUEST;
  if (chmodReal->isChecked ())
    tmp |= REAL;
  ftpxs->setChmod (tmp);
  tmp = 0;
  if (deleteAnon->isChecked ())
    tmp |= ANONYMOUS;
  if (deleteGuest->isChecked ())
    tmp |= GUEST;
  if (deleteReal->isChecked ())
    tmp |= REAL;
  ftpxs->setDelete (tmp);
  tmp = 0;
  if (overwriteAnon->isChecked ())
    tmp |= ANONYMOUS;
  if (overwriteGuest->isChecked ())
    tmp |= GUEST;
  if (overwriteReal->isChecked ())
    tmp |= REAL;
  ftpxs->setOverwrite (tmp);
  tmp = 0;
  if (renameAnon->isChecked ())
    tmp |= ANONYMOUS;
  if (renameGuest->isChecked ())
    tmp |= GUEST;
  if (renameReal->isChecked ())
    tmp |= REAL;
  ftpxs->setRename (tmp);
  tmp = 0;
  if (umaskAnon->isChecked ())
    tmp |= ANONYMOUS;
  if (umaskGuest->isChecked ())
    tmp |= GUEST;
  if (umaskReal->isChecked ())
    tmp |= REAL;
  ftpxs->setUmask (tmp);
  unsigned short pwVal = 0;
  if (PasswdNone->isChecked ())
    pwVal |= NONE;
  else if (PasswdTrivial->isChecked ())
    pwVal |= TRIVIAL;
  else
    pwVal |= RFC822;
  if (PasswdEnforce->isChecked ())
    pwVal |= ENFORCE;
  ftpxs->setPwCheck (pwVal);
}
void Security::redrawNoRetrieves ()
{
  noretrieves->setAutoUpdate (false);
  noretrieves->clear ();
  QStrList *l = ftpxs->getNoRetrieves ();
  char *n = l->first ();
  while (n)
    {
      noretrieves->insertItem (n);
      n = l->next ();
    }
  noretrieves->setAutoUpdate (true);
  noretrieves->update ();
}
void Security::addNoRetPressed ()
{
  AddNoRet *anr = new AddNoRet;
  connect (anr, SIGNAL (noRetAdded (char const *const)), SLOT (noRetAdded (char const *const)));
}
void Security::delNoRetPressed ()
{
  for (unsigned int i=0; i<noretrieves->count(); i++)
    if (noretrieves->isSelected(i))
      ftpxs->getNoRetrieves ()->remove(i);
  redrawNoRetrieves ();
}
void Security::noRetAdded (char const *const filename)
{
  ftpxs->getNoRetrieves()->append(filename);
  redrawNoRetrieves();
}
