#include "Messages.moc"
#include "AddMessage.h"
#include <klocale.h>
#include <kapp.h>
#include <qtooltip.h>

Messages::Messages(QWidget *parent=0, const char *name=0): QWidget(parent, name)
{
	int x=5, y=5;
	int w=640, h=380; // See UserClasses constructor in UserClasses.cpp
	banner=new InputFileCtl(i18n("&Banner"),0,false,0,this);
	banner->setGeometry(x,y,w-10,banner->height());
	y+=banner->height()+5;
	QToolTip::add(banner,i18n("The file selected here will be displayed to\nftp users before login.\nMay break compatibility with truly ancient clients."));
	hostname=new InputCtl(i18n("&Hostname (blank=default)"),0,this);
	hostname->setGeometry(x,y,w-10,hostname->height());
	y+=hostname->height()+5;
	QToolTip::add(hostname,i18n("The hostname given here will be shown at login and for\nthe %L cookie in message files.\nIf this is blank, the canonical hostname of your system will be used."));
	adminmail=new InputCtl(i18n("E-Mail of &admin (for %E):"),0,this);
	adminmail->setGeometry(x,y,w-10,adminmail->height());
	QToolTip::add(adminmail,i18n("E-Mail address returned with the %E cookie in message files."));
	y+=adminmail->height()+5;
	msgShowEverytime=new QCheckBox(i18n("Show &messages every time"), this);
	QToolTip::add(msgShowEverytime,i18n("If this is not checked, message files at CWD will be displayed only once."));
	msgShowEverytime->setGeometry(x,y,msgShowEverytime->sizeHint().width(),msgShowEverytime->height());
	rdmShowEverytime=new QCheckBox(i18n("Show &readmes every time"), this);
	rdmShowEverytime->setGeometry(w/2,y,rdmShowEverytime->sizeHint().width(),rdmShowEverytime->height());
	y+=rdmShowEverytime->height();
	QToolTip::add(rdmShowEverytime,i18n("If this is not checked, hints on README files will be displayed only once."));
	addMsg=new QPushButton(i18n("Add M&essage"),this);
	rmMsg=new QPushButton(i18n("Remo&ve Message"),this);
	addRdm=new QPushButton(i18n("Add Rea&dme"),this);
	rmRdm=new QPushButton(i18n("Rem&ove Readme"),this);
	QLabel *lbl1=new QLabel(i18n("&Messages:"),this);
	lbl1->move(5,y);
	QLabel *lbl2=new QLabel(i18n("&Readmes:"),this);
	lbl2->move(w/2,y);
	y+=lbl1->height();
	messages=new QListBox(this);
	lbl1->setBuddy(messages);
	messages->setGeometry(5,y,w/2-10,h-y-2*height()-10-addMsg->height());
	messages->setAutoUpdate(true);
	messages->setAutoScroll(true);
	addMsg->setGeometry(5,messages->y()+messages->height()+5,w/4-10,addMsg->height());
	rmMsg->setGeometry(w/4+5,messages->y()+messages->height()+5,w/4-10,addMsg->height());
	readmes=new QListBox(this);
	lbl2->setBuddy(readmes);
	readmes->setGeometry(w/2,y,w/2-10,h-y-2*height()-10-addRdm->height());
	readmes->setAutoUpdate(true);
	readmes->setAutoScroll(true);
	addRdm->setGeometry(w/2,messages->y()+messages->height()+5,w/4-10,addMsg->height());
	rmRdm->setGeometry(w*3/4,messages->y()+messages->height()+5,w/4-10,addMsg->height());
	connect(addMsg,SIGNAL(clicked()),SLOT(addMsgPressed()));
	connect(rmMsg,SIGNAL(clicked()),SLOT(rmMsgPressed()));
	connect(addRdm,SIGNAL(clicked()),SLOT(addRdmPressed()));
	connect(rmRdm,SIGNAL(clicked()),SLOT(rmRdmPressed()));
}
Messages::~Messages()
{
}
void Messages::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	banner->setText(xs->getBanner());
	hostname->setText(xs->getHostname());
	adminmail->setText(xs->getAdminMail());
	msgShowEverytime->setChecked(xs->getMsgShowEverytime());
	rdmShowEverytime->setChecked(xs->getRdmShowEverytime());
	redrawLBs();
}
void Messages::redrawLBs()
{
	messages->setAutoUpdate(false);
	messages->clear();
	ftpmessage *m=ftpxs->getFirstMessage();
	while(m) {
		messages->insertItem(m->getId());
		m=ftpxs->getNextMessage(m);
	}
	messages->setAutoUpdate(true);
	messages->update();	
	readmes->setAutoUpdate(false);
	readmes->clear();
	ftpmessage *r=ftpxs->getFirstReadme();
	while(r) {
		readmes->insertItem(r->getId());
		r=ftpxs->getNextReadme(r);
	}
	readmes->setAutoUpdate(true);
	readmes->update();	
}
void Messages::update()
{
	ftpxs->setBanner((char *)banner->text());
	ftpxs->setHostname((char *)hostname->text());
	ftpxs->setAdminMail((char *)adminmail->text());
	ftpxs->setMsgShowEverytime(msgShowEverytime->isChecked());
	ftpxs->setRdmShowEverytime(rdmShowEverytime->isChecked());
}
void Messages::addMsgPressed()
{
	addDlg(false);
}
void Messages::rmMsgPressed()
{
	for(int i=0;i<ftpxs->getNumMessages();i++) 
		if(messages->isSelected(i))
			ftpxs->deleteMessage(i);
	redrawLBs();
}
void Messages::addRdmPressed()
{
	addDlg(true);
}
void Messages::rmRdmPressed()
{
	for(int i=0;i<ftpxs->getNumReadmes();i++) 
		if(readmes->isSelected(i))
			ftpxs->deleteReadme(i);
	redrawLBs();
}
void Messages::addDlg(bool readme)
{
	AddMessage *am=new AddMessage(ftpxs,readme,0);
	connect(am,SIGNAL(MessageAdded(bool, ftpmessage *)),SLOT(MessageAdded(bool, ftpmessage *)));
}
void Messages::MessageAdded(bool readme, ftpmessage *m)
{
	if(readme)
		ftpxs->addReadme(m);
	else
		ftpxs->addMessage(m);
	redrawLBs();
}
